/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.form.engine;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.delegate.VariableScope;
import io.openbpm.bpm.engine.form.FormData;
import io.openbpm.bpm.engine.form.StartFormData;
import io.openbpm.bpm.engine.form.TaskFormData;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.delegate.ScriptInvocation;
import io.openbpm.bpm.engine.impl.form.engine.FormEngine;
import io.openbpm.bpm.engine.impl.persistence.entity.ResourceEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.scripting.ExecutableScript;
import io.openbpm.bpm.engine.impl.scripting.ScriptFactory;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.nio.charset.StandardCharsets;

public class JuelFormEngine
implements FormEngine {
    @Override
    public String getName() {
        return "juel";
    }

    @Override
    public Object renderStartForm(StartFormData startForm) {
        if (startForm.getFormKey() == null) {
            return null;
        }
        String formTemplateString = this.getFormTemplateString(startForm, startForm.getFormKey());
        return this.executeScript(formTemplateString, null);
    }

    @Override
    public Object renderTaskForm(TaskFormData taskForm) {
        if (taskForm.getFormKey() == null) {
            return null;
        }
        String formTemplateString = this.getFormTemplateString(taskForm, taskForm.getFormKey());
        TaskEntity task = (TaskEntity)taskForm.getTask();
        return this.executeScript(formTemplateString, task.getExecution());
    }

    protected Object executeScript(String scriptSrc, VariableScope scope) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ScriptFactory scriptFactory = processEngineConfiguration.getScriptFactory();
        ExecutableScript script = scriptFactory.createScriptFromSource("juel", scriptSrc);
        ScriptInvocation invocation = new ScriptInvocation(script, scope);
        try {
            processEngineConfiguration.getDelegateInterceptor().handleInvocation(invocation);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessEngineException(e);
        }
        return invocation.getInvocationResult();
    }

    protected String getFormTemplateString(FormData formInstance, String formKey) {
        String deploymentId = formInstance.getDeploymentId();
        ResourceEntity resourceStream = Context.getCommandContext().getResourceManager().findResourceByDeploymentIdAndResourceName(deploymentId, formKey);
        EnsureUtil.ensureNotNull("Form with formKey '" + formKey + "' does not exist", "resourceStream", (Object)resourceStream);
        byte[] resourceBytes = resourceStream.getBytes();
        return new String(resourceBytes, StandardCharsets.UTF_8);
    }
}

