/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.form.validator;

import io.openbpm.bpm.application.InvocationContext;
import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.delegate.DelegateExecution;
import io.openbpm.bpm.engine.delegate.Expression;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.context.ProcessApplicationContextUtil;
import io.openbpm.bpm.engine.impl.form.validator.FormFieldValidator;
import io.openbpm.bpm.engine.impl.form.validator.FormFieldValidatorContext;
import io.openbpm.bpm.engine.impl.form.validator.FormFieldValidatorInvocation;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.util.ReflectUtil;

public class DelegateFormFieldValidator
implements FormFieldValidator {
    protected String clazz;
    protected Expression delegateExpression;

    public DelegateFormFieldValidator(Expression expression) {
        this.delegateExpression = expression;
    }

    public DelegateFormFieldValidator(String clazz) {
        this.clazz = clazz;
    }

    public DelegateFormFieldValidator() {
    }

    @Override
    public boolean validate(Object submittedValue, FormFieldValidatorContext validatorContext) {
        DelegateExecution execution = validatorContext.getExecution();
        if (this.shouldPerformPaContextSwitch(validatorContext.getExecution())) {
            ProcessApplicationReference processApplicationReference = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
            return Context.executeWithinProcessApplication(() -> this.doValidate(submittedValue, validatorContext), processApplicationReference, new InvocationContext(execution));
        }
        return this.doValidate(submittedValue, validatorContext);
    }

    protected boolean shouldPerformPaContextSwitch(DelegateExecution execution) {
        if (execution == null) {
            return false;
        }
        ProcessApplicationReference targetPa = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        return targetPa != null && !targetPa.equals(Context.getCurrentProcessApplication());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doValidate(Object submittedValue, FormFieldValidatorContext validatorContext) {
        FormFieldValidator validator;
        if (this.clazz != null) {
            validatorObject = ReflectUtil.instantiate(this.clazz);
            if (!(validatorObject instanceof FormFieldValidator)) throw new ProcessEngineException("Validator class '" + this.clazz + "' is not an instance of " + FormFieldValidator.class.getName());
            validator = formFieldValidator = (FormFieldValidator)validatorObject;
        } else {
            validatorObject = this.delegateExpression.getValue(validatorContext.getExecution());
            if (!(validatorObject instanceof FormFieldValidator)) throw new ProcessEngineException("Validator expression '" + this.delegateExpression + "' does not resolve to instance of " + FormFieldValidator.class.getName());
            validator = formFieldValidator = (FormFieldValidator)validatorObject;
        }
        FormFieldValidatorInvocation invocation = new FormFieldValidatorInvocation(validator, submittedValue, validatorContext);
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
            return invocation.getInvocationResult();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessEngineException(e);
        }
    }
}

