/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.history.parser;

import io.openbpm.bpm.engine.delegate.DelegateExecution;
import io.openbpm.bpm.engine.delegate.ExecutionListener;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.history.event.HistoryEvent;
import io.openbpm.bpm.engine.impl.history.handler.HistoryEventHandler;
import io.openbpm.bpm.engine.impl.history.producer.HistoryEventProducer;

public abstract class HistoryExecutionListener
implements ExecutionListener {
    protected final HistoryEventProducer eventProducer;
    protected HistoryLevel historyLevel;

    protected HistoryExecutionListener(HistoryEventProducer historyEventProducer) {
        this.eventProducer = historyEventProducer;
    }

    @Override
    public void notify(DelegateExecution execution) throws Exception {
        HistoryEventHandler historyEventHandler = Context.getProcessEngineConfiguration().getHistoryEventHandler();
        HistoryEvent historyEvent = this.createHistoryEvent(execution);
        if (historyEvent != null) {
            historyEventHandler.handleEvent(historyEvent);
        }
    }

    protected void ensureHistoryLevelInitialized() {
        if (this.historyLevel == null) {
            this.historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        }
    }

    protected abstract HistoryEvent createHistoryEvent(DelegateExecution var1);
}

