/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.history.producer;

import io.openbpm.bpm.dmn.engine.delegate.DmnDecisionEvaluationEvent;
import io.openbpm.bpm.dmn.engine.delegate.DmnDecisionLiteralExpressionEvaluationEvent;
import io.openbpm.bpm.dmn.engine.delegate.DmnDecisionLogicEvaluationEvent;
import io.openbpm.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationEvent;
import io.openbpm.bpm.dmn.engine.delegate.DmnEvaluatedDecisionRule;
import io.openbpm.bpm.dmn.engine.delegate.DmnEvaluatedInput;
import io.openbpm.bpm.dmn.engine.delegate.DmnEvaluatedOutput;
import io.openbpm.bpm.engine.delegate.DelegateCaseExecution;
import io.openbpm.bpm.engine.delegate.DelegateExecution;
import io.openbpm.bpm.engine.history.HistoricDecisionInputInstance;
import io.openbpm.bpm.engine.history.HistoricDecisionOutputInstance;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import io.openbpm.bpm.engine.impl.cfg.multitenancy.TenantIdProviderHistoricDecisionInstanceContext;
import io.openbpm.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import io.openbpm.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.EnginePersistenceLogger;
import io.openbpm.bpm.engine.impl.history.event.HistoricDecisionEvaluationEvent;
import io.openbpm.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import io.openbpm.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import io.openbpm.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import io.openbpm.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import io.openbpm.bpm.engine.impl.history.event.HistoryEvent;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventTypes;
import io.openbpm.bpm.engine.impl.history.producer.DmnHistoryEventProducer;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.util.ClockUtil;
import io.openbpm.bpm.engine.repository.DecisionDefinition;
import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.engine.variable.value.DoubleValue;
import io.openbpm.bpm.engine.variable.value.IntegerValue;
import io.openbpm.bpm.engine.variable.value.LongValue;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DefaultDmnHistoryEventProducer
implements DmnHistoryEventProducer {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    @Override
    public HistoryEvent createDecisionEvaluatedEvt(DelegateExecution execution, DmnDecisionEvaluationEvent evaluationEvent) {
        return this.createHistoryEvent(evaluationEvent, (evaluationEvent1, rootDecisionInstance) -> this.createDecisionEvaluatedEvt(evaluationEvent1, (ExecutionEntity)execution));
    }

    @Override
    public HistoryEvent createDecisionEvaluatedEvt(DelegateCaseExecution execution, DmnDecisionEvaluationEvent evaluationEvent) {
        return this.createHistoryEvent(evaluationEvent, (evaluationEvent1, rootDecisionInstance) -> this.createDecisionEvaluatedEvt(evaluationEvent1, (CaseExecutionEntity)execution));
    }

    @Override
    public HistoryEvent createDecisionEvaluatedEvt(DmnDecisionEvaluationEvent evaluationEvent) {
        return this.createHistoryEvent(evaluationEvent, this::createDecisionEvaluatedEvt);
    }

    protected HistoryEvent createHistoryEvent(DmnDecisionEvaluationEvent evaluationEvent, HistoricDecisionInstanceSupplier supplier) {
        HistoricDecisionEvaluationEvent event = this.newDecisionEvaluationEvent(evaluationEvent);
        HistoricDecisionInstanceEntity rootDecisionEvent = supplier.createHistoricDecisionInstance(evaluationEvent.getDecisionResult(), null);
        event.setRootHistoricDecisionInstance(rootDecisionEvent);
        ArrayList<HistoricDecisionInstanceEntity> requiredDecisionEvents = new ArrayList<HistoricDecisionInstanceEntity>();
        for (DmnDecisionLogicEvaluationEvent requiredDecisionResult : evaluationEvent.getRequiredDecisionResults()) {
            HistoricDecisionInstanceEntity requiredDecisionEvent = supplier.createHistoricDecisionInstance(requiredDecisionResult, rootDecisionEvent);
            requiredDecisionEvents.add(requiredDecisionEvent);
        }
        event.setRequiredHistoricDecisionInstances(requiredDecisionEvents);
        return event;
    }

    protected HistoricDecisionInstanceEntity createDecisionEvaluatedEvt(DmnDecisionLogicEvaluationEvent evaluationEvent, ExecutionEntity execution) {
        HistoricDecisionInstanceEntity event = this.newDecisionInstanceEventEntity(execution, evaluationEvent);
        this.setReferenceToProcessInstance(event, execution);
        if (this.isHistoryRemovalTimeStrategyStart()) {
            this.provideRemovalTime(event);
        }
        this.initDecisionInstanceEvent(event, evaluationEvent, HistoryEventTypes.DMN_DECISION_EVALUATE);
        DecisionDefinition decisionDefinition = (DecisionDefinition)evaluationEvent.getDecision();
        String tenantId = execution.getTenantId();
        if (tenantId == null) {
            tenantId = this.provideTenantId(decisionDefinition, event);
        }
        event.setTenantId(tenantId);
        return event;
    }

    protected HistoricDecisionInstanceEntity createDecisionEvaluatedEvt(DmnDecisionLogicEvaluationEvent evaluationEvent, CaseExecutionEntity execution) {
        HistoricDecisionInstanceEntity event = this.newDecisionInstanceEventEntity(execution, evaluationEvent);
        this.initDecisionInstanceEvent(event, evaluationEvent, HistoryEventTypes.DMN_DECISION_EVALUATE);
        this.setReferenceToCaseInstance(event, execution);
        DecisionDefinition decisionDefinition = (DecisionDefinition)evaluationEvent.getDecision();
        String tenantId = execution.getTenantId();
        if (tenantId == null) {
            tenantId = this.provideTenantId(decisionDefinition, event);
        }
        event.setTenantId(tenantId);
        return event;
    }

    protected HistoricDecisionInstanceEntity createDecisionEvaluatedEvt(DmnDecisionLogicEvaluationEvent evaluationEvent, HistoricDecisionInstanceEntity rootDecisionInstance) {
        HistoricDecisionInstanceEntity event = this.newDecisionInstanceEventEntity(evaluationEvent);
        this.initDecisionInstanceEvent(event, evaluationEvent, HistoryEventTypes.DMN_DECISION_EVALUATE, rootDecisionInstance);
        this.setUserId(event);
        DecisionDefinition decisionDefinition = (DecisionDefinition)evaluationEvent.getDecision();
        String tenantId = decisionDefinition.getTenantId();
        if (tenantId == null) {
            tenantId = this.provideTenantId(decisionDefinition, event);
        }
        event.setTenantId(tenantId);
        return event;
    }

    protected HistoricDecisionEvaluationEvent newDecisionEvaluationEvent(DmnDecisionEvaluationEvent evaluationEvent) {
        return new HistoricDecisionEvaluationEvent();
    }

    protected HistoricDecisionInstanceEntity newDecisionInstanceEventEntity(ExecutionEntity executionEntity, DmnDecisionLogicEvaluationEvent evaluationEvent) {
        return new HistoricDecisionInstanceEntity();
    }

    protected HistoricDecisionInstanceEntity newDecisionInstanceEventEntity(CaseExecutionEntity executionEntity, DmnDecisionLogicEvaluationEvent evaluationEvent) {
        return new HistoricDecisionInstanceEntity();
    }

    protected HistoricDecisionInstanceEntity newDecisionInstanceEventEntity(DmnDecisionLogicEvaluationEvent evaluationEvent) {
        return new HistoricDecisionInstanceEntity();
    }

    protected void initDecisionInstanceEvent(HistoricDecisionInstanceEntity event, DmnDecisionLogicEvaluationEvent evaluationEvent, HistoryEventTypes eventType) {
        this.initDecisionInstanceEvent(event, evaluationEvent, eventType, null);
    }

    protected void initDecisionInstanceEvent(HistoricDecisionInstanceEntity event, DmnDecisionLogicEvaluationEvent evaluationEvent, HistoryEventTypes eventType, HistoricDecisionInstanceEntity rootDecisionInstance) {
        event.setEventType(eventType.getEventName());
        DecisionDefinition decision = (DecisionDefinition)evaluationEvent.getDecision();
        event.setDecisionDefinitionId(decision.getId());
        event.setDecisionDefinitionKey(decision.getKey());
        event.setDecisionDefinitionName(decision.getName());
        if (decision.getDecisionRequirementsDefinitionId() != null) {
            event.setDecisionRequirementsDefinitionId(decision.getDecisionRequirementsDefinitionId());
            event.setDecisionRequirementsDefinitionKey(decision.getDecisionRequirementsDefinitionKey());
        }
        event.setEvaluationTime(ClockUtil.getCurrentTime());
        if (event.getRootProcessInstanceId() == null && event.getCaseInstanceId() == null) {
            if (rootDecisionInstance != null) {
                event.setRemovalTime(rootDecisionInstance.getRemovalTime());
            } else {
                Date removalTime = this.calculateRemovalTime(event, decision);
                event.setRemovalTime(removalTime);
            }
        }
        if (evaluationEvent instanceof DmnDecisionTableEvaluationEvent) {
            DmnDecisionTableEvaluationEvent tableEvaluationEvent = (DmnDecisionTableEvaluationEvent)evaluationEvent;
            this.initDecisionInstanceEventForDecisionTable(event, tableEvaluationEvent);
        } else if (evaluationEvent instanceof DmnDecisionLiteralExpressionEvaluationEvent) {
            DmnDecisionLiteralExpressionEvaluationEvent expressionEvaluationEvent = (DmnDecisionLiteralExpressionEvaluationEvent)evaluationEvent;
            this.initDecisionInstanceEventForDecisionLiteralExpression(event, expressionEvaluationEvent);
        } else {
            event.setInputs(Collections.emptyList());
            event.setOutputs(Collections.emptyList());
        }
    }

    protected void initDecisionInstanceEventForDecisionTable(HistoricDecisionInstanceEntity event, DmnDecisionTableEvaluationEvent evaluationEvent) {
        if (evaluationEvent.getCollectResultValue() != null) {
            Double collectResultValue = this.getCollectResultValue(evaluationEvent.getCollectResultValue());
            event.setCollectResultValue(collectResultValue);
        }
        List<HistoricDecisionInputInstance> historicDecisionInputInstances = this.createHistoricDecisionInputInstances(evaluationEvent, event.getRootProcessInstanceId(), event.getRemovalTime());
        event.setInputs(historicDecisionInputInstances);
        List<HistoricDecisionOutputInstance> historicDecisionOutputInstances = this.createHistoricDecisionOutputInstances(evaluationEvent, event.getRootProcessInstanceId(), event.getRemovalTime());
        event.setOutputs(historicDecisionOutputInstances);
    }

    protected Double getCollectResultValue(TypedValue collectResultValue) {
        if (collectResultValue instanceof IntegerValue) {
            IntegerValue value = (IntegerValue)collectResultValue;
            return ((Integer)value.getValue()).doubleValue();
        }
        if (collectResultValue instanceof LongValue) {
            LongValue value = (LongValue)collectResultValue;
            return ((Long)value.getValue()).doubleValue();
        }
        if (collectResultValue instanceof DoubleValue) {
            DoubleValue value = (DoubleValue)collectResultValue;
            return (Double)value.getValue();
        }
        throw LOG.collectResultValueOfUnsupportedTypeException(collectResultValue);
    }

    protected List<HistoricDecisionInputInstance> createHistoricDecisionInputInstances(DmnDecisionTableEvaluationEvent evaluationEvent, String rootProcessInstanceId, Date removalTime) {
        ArrayList<HistoricDecisionInputInstance> inputInstances = new ArrayList<HistoricDecisionInputInstance>();
        for (DmnEvaluatedInput inputClause : evaluationEvent.getInputs()) {
            HistoricDecisionInputInstanceEntity inputInstance = new HistoricDecisionInputInstanceEntity(rootProcessInstanceId, removalTime);
            inputInstance.setClauseId(inputClause.getId());
            inputInstance.setClauseName(inputClause.getName());
            inputInstance.setCreateTime(ClockUtil.getCurrentTime());
            TypedValue typedValue = Variables.untypedValue((Object)inputClause.getValue());
            inputInstance.setValue(typedValue);
            inputInstances.add(inputInstance);
        }
        return inputInstances;
    }

    protected List<HistoricDecisionOutputInstance> createHistoricDecisionOutputInstances(DmnDecisionTableEvaluationEvent evaluationEvent, String rootProcessInstanceId, Date removalTime) {
        ArrayList<HistoricDecisionOutputInstance> outputInstances = new ArrayList<HistoricDecisionOutputInstance>();
        List matchingRules = evaluationEvent.getMatchingRules();
        for (int index = 0; index < matchingRules.size(); ++index) {
            DmnEvaluatedDecisionRule rule = (DmnEvaluatedDecisionRule)matchingRules.get(index);
            String ruleId = rule.getId();
            Integer ruleOrder = index + 1;
            for (DmnEvaluatedOutput outputClause : rule.getOutputEntries().values()) {
                HistoricDecisionOutputInstanceEntity outputInstance = new HistoricDecisionOutputInstanceEntity(rootProcessInstanceId, removalTime);
                outputInstance.setClauseId(outputClause.getId());
                outputInstance.setClauseName(outputClause.getName());
                outputInstance.setCreateTime(ClockUtil.getCurrentTime());
                outputInstance.setRuleId(ruleId);
                outputInstance.setRuleOrder(ruleOrder);
                outputInstance.setVariableName(outputClause.getOutputName());
                outputInstance.setValue(outputClause.getValue());
                outputInstances.add(outputInstance);
            }
        }
        return outputInstances;
    }

    protected void initDecisionInstanceEventForDecisionLiteralExpression(HistoricDecisionInstanceEntity event, DmnDecisionLiteralExpressionEvaluationEvent evaluationEvent) {
        event.setInputs(Collections.emptyList());
        HistoricDecisionOutputInstanceEntity outputInstance = new HistoricDecisionOutputInstanceEntity(event.getRootProcessInstanceId(), event.getRemovalTime());
        outputInstance.setVariableName(evaluationEvent.getOutputName());
        outputInstance.setValue(evaluationEvent.getOutputValue());
        event.setOutputs(Collections.singletonList(outputInstance));
    }

    protected void setReferenceToProcessInstance(HistoricDecisionInstanceEntity event, ExecutionEntity execution) {
        event.setProcessDefinitionKey(this.getProcessDefinitionKey(execution));
        event.setProcessDefinitionId(execution.getProcessDefinitionId());
        event.setRootProcessInstanceId(execution.getRootProcessInstanceId());
        event.setProcessInstanceId(execution.getProcessInstanceId());
        event.setExecutionId(execution.getId());
        event.setActivityId(execution.getActivityId());
        event.setActivityInstanceId(execution.getActivityInstanceId());
    }

    protected String getProcessDefinitionKey(ExecutionEntity execution) {
        ProcessDefinitionEntity definition = execution.getProcessDefinition();
        if (definition != null) {
            return definition.getKey();
        }
        return null;
    }

    protected void setReferenceToCaseInstance(HistoricDecisionInstanceEntity event, CaseExecutionEntity execution) {
        event.setCaseDefinitionKey(this.getCaseDefinitionKey(execution));
        event.setCaseDefinitionId(execution.getCaseDefinitionId());
        event.setCaseInstanceId(execution.getCaseInstanceId());
        event.setExecutionId(execution.getId());
        event.setActivityId(execution.getActivityId());
        event.setActivityInstanceId(execution.getId());
    }

    protected String getCaseDefinitionKey(CaseExecutionEntity execution) {
        CaseDefinitionEntity definition = (CaseDefinitionEntity)execution.getCaseDefinition();
        if (definition != null) {
            return definition.getKey();
        }
        return null;
    }

    protected void setUserId(HistoricDecisionInstanceEntity event) {
        event.setUserId(Context.getCommandContext().getAuthenticatedUserId());
    }

    protected String provideTenantId(DecisionDefinition decisionDefinition, HistoricDecisionInstanceEntity event) {
        TenantIdProvider tenantIdProvider = Context.getProcessEngineConfiguration().getTenantIdProvider();
        String tenantId = null;
        if (tenantIdProvider != null) {
            TenantIdProviderHistoricDecisionInstanceContext ctx = null;
            ctx = event.getExecutionId() != null ? new TenantIdProviderHistoricDecisionInstanceContext(decisionDefinition, this.getExecution(event)) : (event.getCaseExecutionId() != null ? new TenantIdProviderHistoricDecisionInstanceContext(decisionDefinition, this.getCaseExecution(event)) : new TenantIdProviderHistoricDecisionInstanceContext(decisionDefinition));
            tenantId = tenantIdProvider.provideTenantIdForHistoricDecisionInstance(ctx);
        }
        return tenantId;
    }

    protected DelegateExecution getExecution(HistoricDecisionInstanceEntity event) {
        return Context.getCommandContext().getExecutionManager().findExecutionById(event.getExecutionId());
    }

    protected DelegateCaseExecution getCaseExecution(HistoricDecisionInstanceEntity event) {
        return Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(event.getCaseExecutionId());
    }

    protected Date calculateRemovalTime(HistoricDecisionInstanceEntity historicDecisionInstance, DecisionDefinition decisionDefinition) {
        return Context.getProcessEngineConfiguration().getHistoryRemovalTimeProvider().calculateRemovalTime(historicDecisionInstance, decisionDefinition);
    }

    protected void provideRemovalTime(HistoryEvent historyEvent) {
        HistoricProcessInstanceEventEntity historicRootProcessInstance;
        String rootProcessInstanceId = historyEvent.getRootProcessInstanceId();
        if (rootProcessInstanceId != null && (historicRootProcessInstance = this.getHistoricRootProcessInstance(rootProcessInstanceId)) != null) {
            Date removalTime = historicRootProcessInstance.getRemovalTime();
            historyEvent.setRemovalTime(removalTime);
        }
    }

    protected boolean isHistoryRemovalTimeStrategyStart() {
        return "start".equals(this.getHistoryRemovalTimeStrategy());
    }

    protected String getHistoryRemovalTimeStrategy() {
        return Context.getProcessEngineConfiguration().getHistoryRemovalTimeStrategy();
    }

    protected HistoricProcessInstanceEventEntity getHistoricRootProcessInstance(String rootProcessInstanceId) {
        return Context.getCommandContext().getDbEntityManager().selectById(HistoricProcessInstanceEventEntity.class, rootProcessInstanceId);
    }

    protected static interface HistoricDecisionInstanceSupplier {
        public HistoricDecisionInstanceEntity createHistoricDecisionInstance(DmnDecisionLogicEvaluationEvent var1, HistoricDecisionInstanceEntity var2);
    }
}

