/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.history.transformer;

import io.openbpm.bpm.engine.delegate.CaseExecutionListener;
import io.openbpm.bpm.engine.impl.cmmn.handler.ItemHandler;
import io.openbpm.bpm.engine.impl.cmmn.model.CmmnActivity;
import io.openbpm.bpm.engine.impl.cmmn.transformer.CmmnTransformListener;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventTypes;
import io.openbpm.bpm.engine.impl.history.producer.CmmnHistoryEventProducer;
import io.openbpm.bpm.engine.impl.history.transformer.CaseActivityInstanceCreateListener;
import io.openbpm.bpm.engine.impl.history.transformer.CaseActivityInstanceEndListener;
import io.openbpm.bpm.engine.impl.history.transformer.CaseActivityInstanceUpdateListener;
import io.openbpm.bpm.engine.impl.history.transformer.CaseInstanceCloseListener;
import io.openbpm.bpm.engine.impl.history.transformer.CaseInstanceCreateListener;
import io.openbpm.bpm.engine.impl.history.transformer.CaseInstanceUpdateListener;
import io.openbpm.bpm.model.cmmn.instance.CasePlanModel;
import io.openbpm.bpm.model.cmmn.instance.CaseTask;
import io.openbpm.bpm.model.cmmn.instance.DecisionTask;
import io.openbpm.bpm.model.cmmn.instance.EventListener;
import io.openbpm.bpm.model.cmmn.instance.HumanTask;
import io.openbpm.bpm.model.cmmn.instance.Milestone;
import io.openbpm.bpm.model.cmmn.instance.PlanItem;
import io.openbpm.bpm.model.cmmn.instance.ProcessTask;
import io.openbpm.bpm.model.cmmn.instance.Stage;
import io.openbpm.bpm.model.cmmn.instance.Task;

public class CmmnHistoryTransformListener
implements CmmnTransformListener {
    protected CaseExecutionListener caseInstanceCreateListener;
    protected CaseExecutionListener caseInstanceUpdateListener;
    protected CaseExecutionListener caseInstanceCloseListener;
    protected CaseExecutionListener caseActivityInstanceCreateListener;
    protected CaseExecutionListener caseActivityInstanceUpdateListener;
    protected CaseExecutionListener caseActivityInstanceEndListener;
    protected HistoryLevel historyLevel;

    public CmmnHistoryTransformListener(CmmnHistoryEventProducer historyEventProducer) {
        this.initCaseExecutionListeners(historyEventProducer);
    }

    protected void initCaseExecutionListeners(CmmnHistoryEventProducer historyEventProducer) {
        this.caseInstanceCreateListener = new CaseInstanceCreateListener(historyEventProducer);
        this.caseInstanceUpdateListener = new CaseInstanceUpdateListener(historyEventProducer);
        this.caseInstanceCloseListener = new CaseInstanceCloseListener(historyEventProducer);
        this.caseActivityInstanceCreateListener = new CaseActivityInstanceCreateListener(historyEventProducer);
        this.caseActivityInstanceUpdateListener = new CaseActivityInstanceUpdateListener(historyEventProducer);
        this.caseActivityInstanceEndListener = new CaseActivityInstanceEndListener(historyEventProducer);
    }

    @Override
    public void transformCasePlanModel(CasePlanModel casePlanModel, CmmnActivity caseActivity) {
        this.addCasePlanModelHandlers(caseActivity);
    }

    @Override
    public void transformHumanTask(PlanItem planItem, HumanTask humanTask, CmmnActivity caseActivity) {
        this.addTaskOrStageHandlers(caseActivity);
    }

    @Override
    public void transformProcessTask(PlanItem planItem, ProcessTask processTask, CmmnActivity caseActivity) {
        this.addTaskOrStageHandlers(caseActivity);
    }

    @Override
    public void transformCaseTask(PlanItem planItem, CaseTask caseTask, CmmnActivity caseActivity) {
        this.addTaskOrStageHandlers(caseActivity);
    }

    @Override
    public void transformDecisionTask(PlanItem planItem, DecisionTask decisionTask, CmmnActivity caseActivity) {
        this.addTaskOrStageHandlers(caseActivity);
    }

    @Override
    public void transformTask(PlanItem planItem, Task task, CmmnActivity caseActivity) {
        this.addTaskOrStageHandlers(caseActivity);
    }

    @Override
    public void transformStage(PlanItem planItem, Stage stage, CmmnActivity caseActivity) {
        this.addTaskOrStageHandlers(caseActivity);
    }

    @Override
    public void transformMilestone(PlanItem planItem, Milestone milestone, CmmnActivity caseActivity) {
        this.addEventListenerOrMilestoneHandlers(caseActivity);
    }

    @Override
    public void transformEventListener(PlanItem planItem, EventListener eventListener, CmmnActivity caseActivity) {
        this.addEventListenerOrMilestoneHandlers(caseActivity);
    }

    protected void addCasePlanModelHandlers(CmmnActivity caseActivity) {
        this.ensureHistoryLevelInitialized();
        if (caseActivity != null) {
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_INSTANCE_CREATE, null)) {
                for (String event : ItemHandler.CASE_PLAN_MODEL_CREATE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.caseInstanceCreateListener);
                }
            }
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_INSTANCE_UPDATE, null)) {
                for (String event : ItemHandler.CASE_PLAN_MODEL_UPDATE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.caseInstanceUpdateListener);
                }
            }
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_INSTANCE_CLOSE, null)) {
                for (String event : ItemHandler.CASE_PLAN_MODEL_CLOSE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.caseInstanceCloseListener);
                }
            }
        }
    }

    protected void addTaskOrStageHandlers(CmmnActivity caseActivity) {
        this.ensureHistoryLevelInitialized();
        if (caseActivity != null) {
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_CREATE, null)) {
                for (String event : ItemHandler.TASK_OR_STAGE_CREATE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.caseActivityInstanceCreateListener);
                }
            }
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_UPDATE, null)) {
                for (String event : ItemHandler.TASK_OR_STAGE_UPDATE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.caseActivityInstanceUpdateListener);
                }
            }
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_END, null)) {
                for (String event : ItemHandler.TASK_OR_STAGE_END_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.caseActivityInstanceEndListener);
                }
            }
        }
    }

    protected void addEventListenerOrMilestoneHandlers(CmmnActivity caseActivity) {
        this.ensureHistoryLevelInitialized();
        if (caseActivity != null) {
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_CREATE, null)) {
                for (String event : ItemHandler.EVENT_LISTENER_OR_MILESTONE_CREATE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.caseActivityInstanceCreateListener);
                }
            }
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_UPDATE, null)) {
                for (String event : ItemHandler.EVENT_LISTENER_OR_MILESTONE_UPDATE_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.caseActivityInstanceUpdateListener);
                }
            }
            if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.CASE_ACTIVITY_INSTANCE_END, null)) {
                for (String event : ItemHandler.EVENT_LISTENER_OR_MILESTONE_END_EVENTS) {
                    caseActivity.addBuiltInListener(event, this.caseActivityInstanceEndListener);
                }
            }
        }
    }

    protected void ensureHistoryLevelInitialized() {
        if (this.historyLevel == null) {
            this.historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        }
    }
}

