/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.interceptor;

import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandInterceptor;
import io.openbpm.bpm.engine.impl.interceptor.TransactionException;
import java.lang.reflect.UndeclaredThrowableException;

public abstract class AbstractTransactionInterceptor
extends CommandInterceptor {
    protected final boolean requiresNew;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    protected AbstractTransactionInterceptor(boolean requiresNew, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.requiresNew = requiresNew;
        this.processEngineConfiguration = processEngineConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Command<T> command) {
        T t;
        Object oldTx = null;
        try {
            T result;
            boolean isNew;
            boolean existing = this.isExisting();
            boolean bl = isNew = !existing || this.requiresNew;
            if (existing && this.requiresNew) {
                oldTx = this.doSuspend();
            }
            if (isNew) {
                this.doBegin();
            }
            try {
                result = this.next.execute(command);
            }
            catch (RuntimeException ex) {
                this.doRollback(isNew);
                throw ex;
            }
            catch (Error err) {
                this.doRollback(isNew);
                throw err;
            }
            catch (Exception ex) {
                this.doRollback(isNew);
                throw new UndeclaredThrowableException(ex, "TransactionCallback threw undeclared checked exception");
            }
            if (isNew) {
                this.doCommit();
            }
            t = result;
            this.doResume(oldTx);
        }
        catch (Throwable throwable) {
            this.doResume(oldTx);
            throw throwable;
        }
        return t;
    }

    protected void handleRollbackException(Exception rollbackException) {
        throw new TransactionException("Unable to commit transaction", rollbackException);
    }

    protected abstract void doResume(Object var1);

    protected abstract void doCommit();

    protected abstract void doRollback(boolean var1);

    protected abstract void doBegin();

    protected abstract Object doSuspend();

    protected abstract boolean isExisting();
}

