/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.interceptor;

import io.openbpm.bpm.application.InvocationContext;
import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.context.ProcessApplicationContextUtil;
import io.openbpm.bpm.engine.impl.interceptor.AtomicOperationInvocation;
import io.openbpm.bpm.engine.impl.interceptor.BpmnStackTrace;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.ProcessDataContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.pvm.runtime.AtomicOperation;
import java.util.ArrayList;
import java.util.List;

public class CommandInvocationContext {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected Throwable throwable;
    protected Command<?> command;
    protected boolean isExecuting;
    protected List<AtomicOperationInvocation> queuedInvocations = new ArrayList<AtomicOperationInvocation>();
    protected BpmnStackTrace bpmnStackTrace = new BpmnStackTrace();
    protected ProcessDataContext processDataContext;

    public CommandInvocationContext(Command<?> command, ProcessEngineConfigurationImpl configuration, boolean isOuterCommand) {
        this.command = command;
        this.processDataContext = new ProcessDataContext(configuration, false, isOuterCommand);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public void trySetThrowable(Throwable t) {
        if (this.throwable == null) {
            this.throwable = t;
        } else {
            LOG.maskedExceptionInCommandContext(this.throwable);
        }
    }

    public void performOperation(AtomicOperation executionOperation, ExecutionEntity execution) {
        this.performOperation(executionOperation, execution, false);
    }

    public void performOperationAsync(AtomicOperation executionOperation, ExecutionEntity execution) {
        this.performOperation(executionOperation, execution, true);
    }

    public void performOperation(AtomicOperation executionOperation, ExecutionEntity execution, boolean performAsync) {
        AtomicOperationInvocation invocation = new AtomicOperationInvocation(executionOperation, execution, performAsync);
        this.queuedInvocations.add(0, invocation);
        this.performNext();
    }

    protected void performNext() {
        AtomicOperationInvocation nextInvocation = this.queuedInvocations.get(0);
        if (nextInvocation.operation.isAsyncCapable() && this.isExecuting) {
            return;
        }
        ProcessApplicationReference targetProcessApplication = this.getTargetProcessApplication(nextInvocation.execution);
        if (this.requiresContextSwitch(targetProcessApplication)) {
            Context.executeWithinProcessApplication(() -> {
                this.performNext();
                return null;
            }, targetProcessApplication, new InvocationContext(nextInvocation.execution));
        } else if (!nextInvocation.operation.isAsyncCapable()) {
            this.invokeNext();
        } else {
            try {
                this.isExecuting = true;
                while (!this.queuedInvocations.isEmpty()) {
                    this.invokeNext();
                }
            }
            finally {
                this.isExecuting = false;
            }
        }
    }

    protected void invokeNext() {
        AtomicOperationInvocation invocation = this.queuedInvocations.remove(0);
        try {
            invocation.execute(this.bpmnStackTrace, this.processDataContext);
        }
        catch (RuntimeException e) {
            this.bpmnStackTrace.printStackTrace(Context.getProcessEngineConfiguration().isBpmnStacktraceVerbose());
            throw e;
        }
    }

    protected boolean requiresContextSwitch(ProcessApplicationReference processApplicationReference) {
        return ProcessApplicationContextUtil.requiresContextSwitch(processApplicationReference);
    }

    protected ProcessApplicationReference getTargetProcessApplication(ExecutionEntity execution) {
        return ProcessApplicationContextUtil.getTargetProcessApplication(execution);
    }

    public void rethrow() {
        if (this.throwable != null) {
            Throwable throwable = this.throwable;
            if (throwable instanceof Error) {
                Error error = (Error)throwable;
                throw error;
            }
            throwable = this.throwable;
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            throw new ProcessEngineException("exception while executing command " + this.command, this.throwable);
        }
    }

    public ProcessDataContext getProcessDataContext() {
        return this.processDataContext;
    }
}

