/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.interceptor;

import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.application.impl.ProcessApplicationContextImpl;
import io.openbpm.bpm.application.impl.ProcessApplicationIdentifier;
import io.openbpm.bpm.container.RuntimeContainerDelegate;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandInterceptor;

public class ProcessApplicationContextInterceptor
extends CommandInterceptor {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ProcessApplicationContextInterceptor(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Command<T> command) {
        ProcessApplicationIdentifier processApplicationIdentifier = ProcessApplicationContextImpl.get();
        if (processApplicationIdentifier != null) {
            ProcessApplicationContextImpl.clear();
            try {
                ProcessApplicationReference reference = this.getPaReference(processApplicationIdentifier);
                Object object = Context.executeWithinProcessApplication(() -> this.next.execute(command), reference);
                return (T)object;
            }
            finally {
                ProcessApplicationContextImpl.set(processApplicationIdentifier);
            }
        }
        return this.next.execute(command);
    }

    protected ProcessApplicationReference getPaReference(ProcessApplicationIdentifier processApplicationIdentifier) {
        if (processApplicationIdentifier.getReference() != null) {
            return processApplicationIdentifier.getReference();
        }
        if (processApplicationIdentifier.getProcessApplication() != null) {
            return processApplicationIdentifier.getProcessApplication().getReference();
        }
        if (processApplicationIdentifier.getName() != null) {
            RuntimeContainerDelegate runtimeContainerDelegate = RuntimeContainerDelegate.INSTANCE.get();
            ProcessApplicationReference reference = runtimeContainerDelegate.getDeployedProcessApplication(processApplicationIdentifier.getName());
            if (reference == null) {
                throw LOG.paWithNameNotRegistered(processApplicationIdentifier.getName());
            }
            return reference;
        }
        throw LOG.cannotReolvePa(processApplicationIdentifier);
    }
}

