/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.jobexecutor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AcquiredJobs {
    protected int numberOfJobsAttemptedToAcquire;
    protected List<List<String>> acquiredJobBatches = new ArrayList<List<String>>();
    protected Set<String> acquiredJobIds = new HashSet<String>();
    protected int numberOfJobsFailedToLock;

    public AcquiredJobs(int numberOfJobsAttemptedToAcquire) {
        this.numberOfJobsAttemptedToAcquire = numberOfJobsAttemptedToAcquire;
    }

    public List<List<String>> getJobIdBatches() {
        return this.acquiredJobBatches;
    }

    public void addJobIdBatch(List<String> jobIds) {
        if (!jobIds.isEmpty()) {
            this.acquiredJobBatches.add(jobIds);
            this.acquiredJobIds.addAll(jobIds);
        }
    }

    public void addJobIdBatch(String jobId) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(jobId);
        this.addJobIdBatch(list);
    }

    public boolean contains(String jobId) {
        return this.acquiredJobIds.contains(jobId);
    }

    public int size() {
        return this.acquiredJobIds.size();
    }

    public void removeJobId(String id) {
        ++this.numberOfJobsFailedToLock;
        this.acquiredJobIds.remove(id);
        Iterator<List<String>> batchIterator = this.acquiredJobBatches.iterator();
        while (batchIterator.hasNext()) {
            List<String> batch = batchIterator.next();
            batch.remove(id);
            if (!batch.isEmpty()) continue;
            batchIterator.remove();
        }
    }

    public int getNumberOfJobsFailedToLock() {
        return this.numberOfJobsFailedToLock;
    }

    public int getNumberOfJobsAttemptedToAcquire() {
        return this.numberOfJobsAttemptedToAcquire;
    }
}

