/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.jobexecutor;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandInvocationContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobHandler;
import io.openbpm.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.process.TransitionImpl;
import io.openbpm.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import io.openbpm.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AsyncContinuationJobHandler
implements JobHandler<AsyncContinuationConfiguration> {
    public static final String TYPE = "async-continuation";
    private final Map<String, PvmAtomicOperation> supportedOperations = new HashMap<String, PvmAtomicOperation>();

    public AsyncContinuationJobHandler() {
        this.supportedOperations.put(PvmAtomicOperation.TRANSITION_CREATE_SCOPE.getCanonicalName(), PvmAtomicOperation.TRANSITION_CREATE_SCOPE);
        this.supportedOperations.put(PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE.getCanonicalName(), PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE);
        this.supportedOperations.put(PvmAtomicOperation.PROCESS_START.getCanonicalName(), PvmAtomicOperation.PROCESS_START);
        this.supportedOperations.put(PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE.getCanonicalName(), PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE);
        this.supportedOperations.put(PvmAtomicOperation.ACTIVITY_END.getCanonicalName(), PvmAtomicOperation.ACTIVITY_END);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(AsyncContinuationConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        LegacyBehavior.repairMultiInstanceAsyncJob(execution);
        PvmAtomicOperation atomicOperation = this.findMatchingAtomicOperation(configuration.getAtomicOperation());
        EnsureUtil.ensureNotNull("Cannot process job with configuration " + configuration, "atomicOperation", (Object)atomicOperation);
        String transitionId = configuration.getTransitionId();
        if (transitionId != null) {
            ActivityImpl activity = execution.getActivity();
            TransitionImpl transition = (TransitionImpl)activity.findOutgoingTransition(transitionId);
            execution.setTransition(transition);
        }
        CommandInvocationContext commandInvocationContext = Objects.requireNonNull(Context.getCommandInvocationContext());
        commandInvocationContext.performOperation(atomicOperation, execution);
    }

    public PvmAtomicOperation findMatchingAtomicOperation(String operationName) {
        if (operationName == null) {
            return PvmAtomicOperation.TRANSITION_CREATE_SCOPE;
        }
        return this.supportedOperations.get(operationName);
    }

    protected boolean isSupported(PvmAtomicOperation atomicOperation) {
        return this.supportedOperations.containsKey(atomicOperation.getCanonicalName());
    }

    @Override
    public AsyncContinuationConfiguration newConfiguration(String canonicalString) {
        String[] configParts = this.tokenizeJobConfiguration(canonicalString);
        AsyncContinuationConfiguration configuration = new AsyncContinuationConfiguration();
        configuration.setAtomicOperation(configParts[0]);
        configuration.setTransitionId(configParts[1]);
        return configuration;
    }

    protected String[] tokenizeJobConfiguration(String jobConfiguration) {
        String[] configuration = new String[2];
        if (jobConfiguration != null) {
            String[] configParts = jobConfiguration.split("\\$");
            if (configParts.length > 2) {
                throw new ProcessEngineException("Illegal async continuation job handler configuration: '" + jobConfiguration + "': expecting one part or two parts separated by '$'.");
            }
            configuration[0] = configParts[0];
            if (configParts.length == 2) {
                configuration[1] = configParts[1];
            }
        }
        return configuration;
    }

    public static class AsyncContinuationConfiguration
    implements JobHandlerConfiguration {
        protected String atomicOperation;
        protected String transitionId;

        public String getAtomicOperation() {
            return this.atomicOperation;
        }

        public void setAtomicOperation(String atomicOperation) {
            this.atomicOperation = atomicOperation;
        }

        public String getTransitionId() {
            return this.transitionId;
        }

        public void setTransitionId(String transitionId) {
            this.transitionId = transitionId;
        }

        @Override
        public String toCanonicalString() {
            Object configuration = this.atomicOperation;
            if (this.transitionId != null) {
                configuration = (String)configuration + "$" + this.transitionId;
            }
            return configuration;
        }
    }
}

