/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.jobexecutor;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.TransactionListener;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutorContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutorLogger;

public class ExclusiveJobAddedNotification
implements TransactionListener {
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    protected final String jobId;
    protected final JobExecutorContext jobExecutorContext;

    public ExclusiveJobAddedNotification(String jobId, JobExecutorContext jobExecutorContext) {
        this.jobId = jobId;
        this.jobExecutorContext = jobExecutorContext;
    }

    @Override
    public void execute(CommandContext commandContext) {
        LOG.debugAddingNewExclusiveJobToJobExecutorCOntext(this.jobId);
        this.jobExecutorContext.getCurrentProcessorJobQueue().add(this.jobId);
        this.logExclusiveJobAdded(commandContext);
    }

    protected void logExclusiveJobAdded(CommandContext commandContext) {
        if (commandContext.getProcessEngineConfiguration().isMetricsEnabled()) {
            commandContext.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence("job-locked-exclusive");
        }
    }
}

