/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.jobexecutor;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.jobexecutor.FailedJobCommandFactory;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import io.openbpm.bpm.engine.impl.jobexecutor.JobFailureCollector;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;

public class FailedJobListener
implements Command<Void> {
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    protected CommandExecutor commandExecutor;
    protected JobFailureCollector jobFailureCollector;
    protected int countRetries;
    protected int totalRetries = 3;

    public FailedJobListener(CommandExecutor commandExecutor, JobFailureCollector jobFailureCollector) {
        this.commandExecutor = commandExecutor;
        this.jobFailureCollector = jobFailureCollector;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.isJobReacquired(commandContext)) {
            LOG.debugFailedJobListenerSkipped(this.jobFailureCollector.getJobId());
            return null;
        }
        this.initTotalRetries(commandContext);
        this.logJobFailure(commandContext);
        FailedJobCommandFactory failedJobCommandFactory = commandContext.getFailedJobCommandFactory();
        String jobId = this.jobFailureCollector.getJobId();
        Command<Object> cmd = failedJobCommandFactory.getCommand(jobId, this.jobFailureCollector.getFailure());
        this.commandExecutor.execute(new FailedJobListenerCmd(jobId, cmd));
        return null;
    }

    protected boolean isJobReacquired(CommandContext commandContext) {
        JobEntity persistedJob = commandContext.getJobManager().findJobById(this.jobFailureCollector.getJobId());
        JobEntity job = this.jobFailureCollector.getJob();
        if (persistedJob == null || persistedJob.getLockExpirationTime() == null) {
            return false;
        }
        return !persistedJob.getLockExpirationTime().equals(job.getLockExpirationTime());
    }

    private void initTotalRetries(CommandContext commandContext) {
        this.totalRetries = commandContext.getProcessEngineConfiguration().getFailedJobListenerMaxRetries();
    }

    protected void fireHistoricJobFailedEvt(JobEntity job) {
        CommandContext commandContext = Context.getCommandContext();
        job.incrementSequenceCounter();
        commandContext.getHistoricJobLogManager().fireJobFailedEvent(job, this.jobFailureCollector.getFailure());
    }

    protected void logJobFailure(CommandContext commandContext) {
        if (commandContext.getProcessEngineConfiguration().isMetricsEnabled()) {
            commandContext.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence("job-failed");
        }
    }

    public void incrementCountRetries() {
        ++this.countRetries;
    }

    public int getRetriesLeft() {
        return Math.max(0, this.totalRetries - this.countRetries);
    }

    protected class FailedJobListenerCmd
    implements Command<Void> {
        protected String jobId;
        protected Command<Object> cmd;

        public FailedJobListenerCmd(String jobId, Command<Object> cmd) {
            this.jobId = jobId;
            this.cmd = cmd;
        }

        @Override
        public Void execute(CommandContext commandContext) {
            JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
            if (job != null) {
                job.setFailedActivityId(FailedJobListener.this.jobFailureCollector.getFailedActivityId());
                FailedJobListener.this.fireHistoricJobFailedEvt(job);
                this.cmd.execute(commandContext);
            } else {
                LOG.debugFailedJobNotFound(this.jobId);
            }
            return null;
        }
    }
}

