/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.jobexecutor;

import io.openbpm.bpm.engine.impl.ProcessEngineImpl;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.jobexecutor.AcquireJobsCommandFactory;
import io.openbpm.bpm.engine.impl.jobexecutor.AcquireJobsRunnable;
import io.openbpm.bpm.engine.impl.jobexecutor.AcquiredJobs;
import io.openbpm.bpm.engine.impl.jobexecutor.DefaultAcquireJobsCommandFactory;
import io.openbpm.bpm.engine.impl.jobexecutor.ExecuteJobsRunnable;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import io.openbpm.bpm.engine.impl.jobexecutor.RejectedJobsHandler;
import io.openbpm.bpm.engine.impl.jobexecutor.SequentialJobAcquisitionRunnable;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class JobExecutor {
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    protected String name = "JobExecutor[" + this.getClass().getName() + "]";
    protected List<ProcessEngineImpl> processEngines = new CopyOnWriteArrayList<ProcessEngineImpl>();
    protected AcquireJobsCommandFactory acquireJobsCmdFactory;
    protected AcquireJobsRunnable acquireJobsRunnable;
    protected RejectedJobsHandler rejectedJobsHandler;
    protected Thread jobAcquisitionThread;
    protected boolean isAutoActivate;
    protected boolean isActive;
    protected int maxJobsPerAcquisition = 3;
    protected int waitTimeInMillis = 5000;
    protected float waitIncreaseFactor = 2.0f;
    protected long maxWait = 60000L;
    protected int backoffTimeInMillis;
    protected long maxBackoff;
    protected int backoffDecreaseThreshold = 100;
    protected String lockOwner = UUID.randomUUID().toString();
    protected int lockTimeInMillis = 300000;

    public void start() {
        if (this.isActive) {
            return;
        }
        LOG.startingUpJobExecutor(this.getClass().getName());
        this.ensureInitialization();
        this.startExecutingJobs();
        this.isActive = true;
    }

    public synchronized void shutdown() {
        if (!this.isActive) {
            return;
        }
        LOG.shuttingDownTheJobExecutor(this.getClass().getName());
        this.acquireJobsRunnable.stop();
        this.stopExecutingJobs();
        this.ensureCleanup();
        this.isActive = false;
    }

    protected void ensureInitialization() {
        if (this.acquireJobsCmdFactory == null) {
            this.acquireJobsCmdFactory = new DefaultAcquireJobsCommandFactory(this);
        }
        this.acquireJobsRunnable = new SequentialJobAcquisitionRunnable(this);
    }

    protected void ensureCleanup() {
        this.acquireJobsCmdFactory = null;
        this.acquireJobsRunnable = null;
    }

    public void jobWasAdded() {
        if (this.isActive) {
            this.acquireJobsRunnable.jobWasAdded();
        }
    }

    public synchronized void registerProcessEngine(ProcessEngineImpl processEngine) {
        this.processEngines.add(processEngine);
        if (this.processEngines.size() == 1 && this.isAutoActivate) {
            this.start();
        }
    }

    public synchronized void unregisterProcessEngine(ProcessEngineImpl processEngine) {
        this.processEngines.remove(processEngine);
        if (this.processEngines.isEmpty() && this.isActive) {
            this.shutdown();
        }
    }

    protected abstract void startExecutingJobs();

    protected abstract void stopExecutingJobs();

    public abstract void executeJobs(List<String> var1, ProcessEngineImpl var2);

    @Deprecated(forRemoval=true, since="1.0")
    public void executeJobs(List<String> jobIds) {
        if (!this.processEngines.isEmpty()) {
            this.executeJobs(jobIds, this.processEngines.get(0));
        }
    }

    public void logAcquisitionAttempt(ProcessEngineImpl engine) {
        if (engine.getProcessEngineConfiguration().isMetricsEnabled()) {
            engine.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence("job-acquisition-attempt");
        }
    }

    public void logAcquiredJobs(ProcessEngineImpl engine, int numJobs) {
        if (engine != null && engine.getProcessEngineConfiguration().isMetricsEnabled()) {
            engine.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence("job-acquired-success", numJobs);
        }
    }

    public void logAcquisitionFailureJobs(ProcessEngineImpl engine, int numJobs) {
        if (engine != null && engine.getProcessEngineConfiguration().isMetricsEnabled()) {
            engine.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence("job-acquired-failure", numJobs);
        }
    }

    public void logRejectedExecution(ProcessEngineImpl engine, int numJobs) {
        if (engine != null) {
            LOG.rejectedJobExecutions(engine.getName(), numJobs);
            if (engine.getProcessEngineConfiguration().isMetricsEnabled()) {
                engine.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence("job-execution-rejected", numJobs);
            }
        }
    }

    public void logJobExecutionInfo(ProcessEngineImpl engine, int executionQueueSize, int executionQueueCapacity, int maxExecutionThreads, int activeExecutionThreads) {
        if (engine != null) {
            LOG.currentJobExecutions(engine.getName(), activeExecutionThreads);
            LOG.numJobsInQueue(engine.getName(), executionQueueSize, executionQueueCapacity);
            try {
                LOG.availableJobExecutionThreads(engine.getName(), Math.subtractExact(maxExecutionThreads, activeExecutionThreads));
            }
            catch (ArithmeticException arithmeticException) {
                LOG.availableThreadsCalculationError();
            }
        }
    }

    public int calculateTotalQueueCapacity(int availableItems, int remainingCapacity) {
        int totalQueueCapacity = 0;
        try {
            totalQueueCapacity = Math.addExact(availableItems, remainingCapacity);
        }
        catch (ArithmeticException arithmeticException) {
            LOG.totalQueueCapacityCalculationError();
        }
        return totalQueueCapacity;
    }

    public List<ProcessEngineImpl> getProcessEngines() {
        return this.processEngines;
    }

    public Iterator<ProcessEngineImpl> engineIterator() {
        return this.processEngines.iterator();
    }

    public boolean hasRegisteredEngine(ProcessEngineImpl engine) {
        return this.processEngines.contains(engine);
    }

    @Deprecated(forRemoval=true, since="1.0")
    public CommandExecutor getCommandExecutor() {
        if (this.processEngines.isEmpty()) {
            return null;
        }
        return this.processEngines.get(0).getProcessEngineConfiguration().getCommandExecutorTxRequired();
    }

    @Deprecated(forRemoval=true, since="1.0")
    public void setCommandExecutor(CommandExecutor commandExecutorTxRequired) {
    }

    public int getWaitTimeInMillis() {
        return this.waitTimeInMillis;
    }

    public void setWaitTimeInMillis(int waitTimeInMillis) {
        this.waitTimeInMillis = waitTimeInMillis;
    }

    public int getBackoffTimeInMillis() {
        return this.backoffTimeInMillis;
    }

    public void setBackoffTimeInMillis(int backoffTimeInMillis) {
        this.backoffTimeInMillis = backoffTimeInMillis;
    }

    public int getLockTimeInMillis() {
        return this.lockTimeInMillis;
    }

    public void setLockTimeInMillis(int lockTimeInMillis) {
        this.lockTimeInMillis = lockTimeInMillis;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    public boolean isAutoActivate() {
        return this.isAutoActivate;
    }

    public void setProcessEngines(List<ProcessEngineImpl> processEngines) {
        this.processEngines = processEngines;
    }

    public void setAutoActivate(boolean isAutoActivate) {
        this.isAutoActivate = isAutoActivate;
    }

    public int getMaxJobsPerAcquisition() {
        return this.maxJobsPerAcquisition;
    }

    public void setMaxJobsPerAcquisition(int maxJobsPerAcquisition) {
        this.maxJobsPerAcquisition = maxJobsPerAcquisition;
    }

    public float getWaitIncreaseFactor() {
        return this.waitIncreaseFactor;
    }

    public void setWaitIncreaseFactor(float waitIncreaseFactor) {
        this.waitIncreaseFactor = waitIncreaseFactor;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public long getMaxBackoff() {
        return this.maxBackoff;
    }

    public void setMaxBackoff(long maxBackoff) {
        this.maxBackoff = maxBackoff;
    }

    public int getBackoffDecreaseThreshold() {
        return this.backoffDecreaseThreshold;
    }

    public void setBackoffDecreaseThreshold(int backoffDecreaseThreshold) {
        this.backoffDecreaseThreshold = backoffDecreaseThreshold;
    }

    public String getName() {
        return this.name;
    }

    public Command<AcquiredJobs> getAcquireJobsCmd(int numJobs) {
        return this.acquireJobsCmdFactory.getCommand(numJobs);
    }

    public AcquireJobsCommandFactory getAcquireJobsCmdFactory() {
        return this.acquireJobsCmdFactory;
    }

    public void setAcquireJobsCmdFactory(AcquireJobsCommandFactory acquireJobsCmdFactory) {
        this.acquireJobsCmdFactory = acquireJobsCmdFactory;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public RejectedJobsHandler getRejectedJobsHandler() {
        return this.rejectedJobsHandler;
    }

    public void setRejectedJobsHandler(RejectedJobsHandler rejectedJobsHandler) {
        this.rejectedJobsHandler = rejectedJobsHandler;
    }

    protected void startJobAcquisitionThread() {
        if (this.jobAcquisitionThread == null) {
            this.jobAcquisitionThread = new Thread((Runnable)this.acquireJobsRunnable, this.getName());
            this.jobAcquisitionThread.start();
        }
    }

    protected void stopJobAcquisitionThread() {
        try {
            this.jobAcquisitionThread.join();
        }
        catch (InterruptedException e) {
            LOG.interruptedWhileShuttingDownjobExecutor(e);
        }
        this.jobAcquisitionThread = null;
    }

    public AcquireJobsRunnable getAcquireJobsRunnable() {
        return this.acquireJobsRunnable;
    }

    public Runnable getExecuteJobsRunnable(List<String> jobIds, ProcessEngineImpl processEngine) {
        return new ExecuteJobsRunnable(jobIds, processEngine);
    }
}

