/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.jobexecutor.historycleanup;

import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHandler;
import io.openbpm.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoryCleanupBatch
extends HistoryCleanupHandler {
    protected List<String> historicProcessInstanceIds = Collections.emptyList();
    protected List<String> historicDecisionInstanceIds = Collections.emptyList();
    protected List<String> historicCaseInstanceIds = Collections.emptyList();
    protected List<String> historicBatchIds = Collections.emptyList();
    protected List<String> taskMetricIds = Collections.emptyList();

    public List<String> getHistoricProcessInstanceIds() {
        return this.historicProcessInstanceIds;
    }

    public void setHistoricProcessInstanceIds(List<String> historicProcessInstanceIds) {
        this.historicProcessInstanceIds = historicProcessInstanceIds;
    }

    public List<String> getHistoricDecisionInstanceIds() {
        return this.historicDecisionInstanceIds;
    }

    public void setHistoricDecisionInstanceIds(List<String> historicDecisionInstanceIds) {
        this.historicDecisionInstanceIds = historicDecisionInstanceIds;
    }

    public List<String> getHistoricCaseInstanceIds() {
        return this.historicCaseInstanceIds;
    }

    public void setHistoricCaseInstanceIds(List<String> historicCaseInstanceIds) {
        this.historicCaseInstanceIds = historicCaseInstanceIds;
    }

    public List<String> getHistoricBatchIds() {
        return this.historicBatchIds;
    }

    public void setHistoricBatchIds(List<String> historicBatchIds) {
        this.historicBatchIds = historicBatchIds;
    }

    public List<String> getTaskMetricIds() {
        return this.taskMetricIds;
    }

    public void setTaskMetricIds(List<String> taskMetricIds) {
        this.taskMetricIds = taskMetricIds;
    }

    public int size() {
        return this.historicProcessInstanceIds.size() + this.historicDecisionInstanceIds.size() + this.historicCaseInstanceIds.size() + this.historicBatchIds.size() + this.taskMetricIds.size();
    }

    @Override
    public void performCleanup() {
        CommandContext commandContext = Context.getCommandContext();
        HistoryCleanupHelper.prepareNextBatch(this, commandContext);
        if (this.size() > 0) {
            if (!this.historicProcessInstanceIds.isEmpty()) {
                commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceByIds(this.historicProcessInstanceIds);
            }
            if (!this.historicDecisionInstanceIds.isEmpty()) {
                commandContext.getHistoricDecisionInstanceManager().deleteHistoricDecisionInstanceByIds(this.historicDecisionInstanceIds);
            }
            if (!this.historicCaseInstanceIds.isEmpty()) {
                commandContext.getHistoricCaseInstanceManager().deleteHistoricCaseInstancesByIds(this.historicCaseInstanceIds);
            }
            if (!this.historicBatchIds.isEmpty()) {
                commandContext.getHistoricBatchManager().deleteHistoricBatchesByIds(this.historicBatchIds);
            }
            if (!this.taskMetricIds.isEmpty()) {
                commandContext.getMeterLogManager().deleteTaskMetricsById(this.taskMetricIds);
            }
        }
    }

    @Override
    protected Map<String, Long> reportMetrics() {
        HashMap<String, Long> reports = new HashMap<String, Long>();
        if (!this.historicProcessInstanceIds.isEmpty()) {
            reports.put("history-cleanup-removed-process-instances", Long.valueOf(this.historicProcessInstanceIds.size()));
        }
        if (!this.historicDecisionInstanceIds.isEmpty()) {
            reports.put("history-cleanup-removed-decision-instances", Long.valueOf(this.historicDecisionInstanceIds.size()));
        }
        if (!this.historicCaseInstanceIds.isEmpty()) {
            reports.put("history-cleanup-removed-case-instances", Long.valueOf(this.historicCaseInstanceIds.size()));
        }
        if (!this.historicBatchIds.isEmpty()) {
            reports.put("history-cleanup-removed-batch-operations", Long.valueOf(this.historicBatchIds.size()));
        }
        if (!this.taskMetricIds.isEmpty()) {
            reports.put("history-cleanup-removed-task-metrics", Long.valueOf(this.taskMetricIds.size()));
        }
        return reports;
    }

    @Override
    boolean shouldRescheduleNow() {
        return this.size() >= this.getBatchSizeThreshold();
    }

    public Integer getBatchSizeThreshold() {
        return Context.getProcessEngineConfiguration().getHistoryCleanupBatchThreshold();
    }
}

