/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.json;

import io.openbpm.bpm.engine.impl.json.JsonArrayConverter;
import io.openbpm.bpm.engine.impl.json.JsonObjectConverter;
import io.openbpm.bpm.engine.impl.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import openbpmjar.impl.com.google.gson.JsonArray;
import openbpmjar.impl.com.google.gson.JsonElement;
import openbpmjar.impl.com.google.gson.JsonObject;

public class JsonArrayOfObjectsConverter<T>
extends JsonArrayConverter<List<T>> {
    protected JsonObjectConverter<T> objectConverter;

    public JsonArrayOfObjectsConverter(JsonObjectConverter<T> objectConverter) {
        this.objectConverter = objectConverter;
    }

    @Override
    public JsonArray toJsonArray(List<T> objects) {
        JsonArray jsonArray = JsonUtil.createArray();
        for (T object : objects) {
            JsonObject jsonObject = this.objectConverter.toJsonObject(object);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    @Override
    public List<T> toObject(JsonArray jsonArray) {
        ArrayList<T> result = new ArrayList<T>();
        for (JsonElement jsonElement : jsonArray) {
            T object = this.objectConverter.toObject(JsonUtil.getObject(jsonElement));
            result.add(object);
        }
        return result;
    }
}

