/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.management;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.cmd.SetJobRetriesCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.management.SetJobRetriesBuilder;
import java.util.Date;
import java.util.List;

public class SetJobRetriesBuilderImpl
implements SetJobRetriesBuilder {
    protected static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final CommandExecutor commandExecutor;
    protected String jobId;
    protected List<String> jobIds;
    protected String jobDefinitionId;
    protected Integer retries;
    protected Date dueDate;
    protected boolean isDueDateSet;
    boolean byJobId;
    boolean byJobIds;
    boolean byJobDefinitionId;

    public SetJobRetriesBuilderImpl(CommandExecutor commandExecutor, int retries) {
        this.commandExecutor = commandExecutor;
        this.retries = retries;
    }

    @Override
    public SetJobRetriesBuilder jobId(String jobId) {
        this.jobId = jobId;
        this.byJobId = true;
        return this;
    }

    @Override
    public SetJobRetriesBuilder jobIds(List<String> jobIds) {
        this.jobIds = jobIds;
        this.byJobIds = true;
        return this;
    }

    @Override
    public SetJobRetriesBuilder jobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
        this.byJobDefinitionId = true;
        return this;
    }

    @Override
    public SetJobRetriesBuilder dueDate(Date dueDate) {
        this.isDueDateSet = true;
        this.dueDate = dueDate;
        return this;
    }

    @Override
    public void execute() {
        this.validateParameters();
        if (this.byJobId || this.byJobDefinitionId) {
            this.commandExecutor.execute(new SetJobRetriesCmd(this.jobId, this.jobDefinitionId, this.retries, this.dueDate, this.isDueDateSet));
        } else if (this.byJobIds) {
            this.commandExecutor.execute(new SetJobRetriesCmd(this.jobIds, this.retries, this.dueDate, this.isDueDateSet));
        }
    }

    protected void validateParameters() {
        EnsureUtil.ensureNotNull("commandExecutor", (Object)this.commandExecutor);
        EnsureUtil.ensureNotNull("retries", (Object)this.retries);
        if (this.retries < 0) {
            throw LOG.exceptionJobRetriesMustNotBeNegative(this.retries);
        }
        if (!(this.byJobId ^ this.byJobIds ^ this.byJobDefinitionId)) {
            throw LOG.exceptionSettingJobRetriesJobsNotSpecifiedCorrectly();
        }
        if (this.byJobId || this.byJobDefinitionId) {
            if ((this.jobId == null || this.jobId.isEmpty()) && (this.jobDefinitionId == null || this.jobDefinitionId.isEmpty())) {
                throw LOG.exceptionSettingJobRetriesJobsNotSpecifiedCorrectly();
            }
        } else if (this.byJobIds) {
            EnsureUtil.ensureNotEmpty("job ids", this.jobIds);
        }
    }
}

