/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.management;

import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.cmd.SetJobsRetriesBatchCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.management.SetJobRetriesAsyncBuilder;
import io.openbpm.bpm.engine.management.SetJobRetriesByJobsAsyncBuilder;
import io.openbpm.bpm.engine.runtime.JobQuery;
import java.util.Date;
import java.util.List;

public class SetJobRetriesByJobsAsyncBuilderImpl
implements SetJobRetriesByJobsAsyncBuilder {
    protected static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final CommandExecutor commandExecutor;
    protected List<String> jobIds;
    protected JobQuery jobQuery;
    protected Integer retries;
    protected Date dueDate;
    protected boolean isDueDateSet;

    public SetJobRetriesByJobsAsyncBuilderImpl(CommandExecutor commandExecutor, int retries) {
        this.commandExecutor = commandExecutor;
        this.retries = retries;
    }

    @Override
    public SetJobRetriesByJobsAsyncBuilder jobQuery(JobQuery query) {
        this.jobQuery = query;
        return this;
    }

    @Override
    public SetJobRetriesByJobsAsyncBuilder jobIds(List<String> jobIds) {
        this.jobIds = jobIds;
        return this;
    }

    @Override
    public SetJobRetriesAsyncBuilder dueDate(Date dueDate) {
        this.dueDate = dueDate;
        this.isDueDateSet = true;
        return this;
    }

    @Override
    public Batch executeAsync() {
        this.validateParameters();
        return this.commandExecutor.execute(new SetJobsRetriesBatchCmd(this.jobIds, this.jobQuery, this.retries, this.dueDate, this.isDueDateSet));
    }

    protected void validateParameters() {
        EnsureUtil.ensureNotNull("commandExecutor", (Object)this.commandExecutor);
        EnsureUtil.ensureNotNull("retries", (Object)this.retries);
        if ((this.jobIds == null || this.jobIds.isEmpty()) && this.jobQuery == null) {
            throw LOG.exceptionSettingJobRetriesAsyncNoJobsSpecified();
        }
    }
}

