/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.management;

import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.SetJobsRetriesByProcessBatchCmd;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.management.SetJobRetriesByProcessAsyncBuilder;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import java.util.Date;
import java.util.List;

public class SetJobRetriesByProcessAsyncBuilderImpl
implements SetJobRetriesByProcessAsyncBuilder {
    protected static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final CommandExecutor commandExecutor;
    protected List<String> processInstanceIds;
    protected ProcessInstanceQuery processInstanceQuery;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;
    protected Integer retries;
    protected Date dueDate;
    protected boolean isDueDateSet;

    public SetJobRetriesByProcessAsyncBuilderImpl(CommandExecutor commandExecutor, int retries) {
        this.commandExecutor = commandExecutor;
        this.retries = retries;
    }

    @Override
    public SetJobRetriesByProcessAsyncBuilder processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public SetJobRetriesByProcessAsyncBuilder processInstanceQuery(ProcessInstanceQuery query) {
        this.processInstanceQuery = query;
        return this;
    }

    @Override
    public SetJobRetriesByProcessAsyncBuilder historicProcessInstanceQuery(HistoricProcessInstanceQuery query) {
        this.historicProcessInstanceQuery = query;
        return this;
    }

    @Override
    public SetJobRetriesByProcessAsyncBuilder dueDate(Date dueDate) {
        this.dueDate = dueDate;
        this.isDueDateSet = true;
        return this;
    }

    @Override
    public Batch executeAsync() {
        this.validateParameters();
        return this.commandExecutor.execute(new SetJobsRetriesByProcessBatchCmd(this.processInstanceIds, this.processInstanceQuery, this.historicProcessInstanceQuery, this.retries, this.dueDate, this.isDueDateSet));
    }

    protected void validateParameters() {
        boolean isHistoricProcessInstanceQueryNull;
        EnsureUtil.ensureNotNull("commandExecutor", (Object)this.commandExecutor);
        EnsureUtil.ensureNotNull("retries", (Object)this.retries);
        boolean isProcessInstanceIdsNull = this.processInstanceIds == null || this.processInstanceIds.isEmpty();
        boolean isProcessInstanceQueryNull = this.processInstanceQuery == null;
        boolean bl = isHistoricProcessInstanceQueryNull = this.historicProcessInstanceQuery == null;
        if (isProcessInstanceIdsNull && isProcessInstanceQueryNull && isHistoricProcessInstanceQueryNull) {
            throw LOG.exceptionSettingJobRetriesAsyncNoProcessesSpecified();
        }
    }
}

