/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.metrics.reporter;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.metrics.Meter;
import io.openbpm.bpm.engine.impl.metrics.MetricsLogger;
import io.openbpm.bpm.engine.impl.metrics.MetricsRegistry;
import io.openbpm.bpm.engine.impl.persistence.entity.MeterLogEntity;
import io.openbpm.bpm.engine.impl.util.ClockUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;

public class MetricsCollectionTask
extends TimerTask {
    private static final MetricsLogger LOG = ProcessEngineLogger.METRICS_LOGGER;
    protected MetricsRegistry metricsRegistry;
    protected CommandExecutor commandExecutor;
    protected String reporterId;

    public MetricsCollectionTask(MetricsRegistry metricsRegistry, CommandExecutor commandExecutor) {
        this.metricsRegistry = metricsRegistry;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public void run() {
        try {
            this.collectMetrics();
        }
        catch (Exception e) {
            try {
                LOG.couldNotCollectAndLogMetrics(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void collectMetrics() {
        ArrayList<MeterLogEntity> logs = new ArrayList<MeterLogEntity>();
        for (Meter meter : this.metricsRegistry.getDbMeters().values()) {
            logs.add(new MeterLogEntity(meter.getName(), this.reporterId, meter.getAndClear(), ClockUtil.getCurrentTime()));
        }
        this.commandExecutor.execute(new MetricsCollectionCmd(logs));
    }

    public String getReporter() {
        return this.reporterId;
    }

    public void setReporter(String reporterId) {
        this.reporterId = reporterId;
    }

    protected class MetricsCollectionCmd
    implements Command<Void> {
        protected List<MeterLogEntity> logs;

        public MetricsCollectionCmd(List<MeterLogEntity> logs) {
            this.logs = logs;
        }

        @Override
        public Void execute(CommandContext commandContext) {
            for (MeterLogEntity meterLogEntity : this.logs) {
                commandContext.getMeterLogManager().insert(meterLogEntity);
            }
            return null;
        }
    }
}

