/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration;

import io.openbpm.bpm.engine.impl.cmd.CreateMigrationPlanCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.migration.MigrationInstructionImpl;
import io.openbpm.bpm.engine.migration.MigrationInstructionBuilder;
import io.openbpm.bpm.engine.migration.MigrationInstructionsBuilder;
import io.openbpm.bpm.engine.migration.MigrationPlan;
import io.openbpm.bpm.engine.migration.MigrationPlanBuilder;
import io.openbpm.bpm.engine.variable.VariableMap;
import io.openbpm.bpm.engine.variable.impl.VariableMapImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MigrationPlanBuilderImpl
implements MigrationInstructionBuilder,
MigrationInstructionsBuilder {
    protected CommandExecutor commandExecutor;
    protected String sourceProcessDefinitionId;
    protected String targetProcessDefinitionId;
    protected List<MigrationInstructionImpl> explicitMigrationInstructions;
    protected boolean mapEqualActivities;
    protected boolean updateEventTriggersForGeneratedInstructions;
    protected VariableMap variables;

    public MigrationPlanBuilderImpl(CommandExecutor commandExecutor, String sourceProcessDefinitionId, String targetProcessDefinitionId) {
        this.commandExecutor = commandExecutor;
        this.sourceProcessDefinitionId = sourceProcessDefinitionId;
        this.targetProcessDefinitionId = targetProcessDefinitionId;
        this.explicitMigrationInstructions = new ArrayList<MigrationInstructionImpl>();
    }

    @Override
    public MigrationInstructionsBuilder mapEqualActivities() {
        this.mapEqualActivities = true;
        return this;
    }

    @Override
    public MigrationPlanBuilder setVariables(Map<String, ?> variables) {
        if (variables instanceof VariableMapImpl) {
            VariableMapImpl impl = (VariableMapImpl)variables;
            this.variables = impl;
        } else if (variables != null) {
            this.variables = new VariableMapImpl(new HashMap(variables));
        }
        return this;
    }

    @Override
    public MigrationInstructionBuilder mapActivities(String sourceActivityId, String targetActivityId) {
        this.explicitMigrationInstructions.add(new MigrationInstructionImpl(sourceActivityId, targetActivityId));
        return this;
    }

    @Override
    public MigrationInstructionBuilder updateEventTrigger() {
        this.explicitMigrationInstructions.get(this.explicitMigrationInstructions.size() - 1).setUpdateEventTrigger(true);
        return this;
    }

    @Override
    public MigrationInstructionsBuilder updateEventTriggers() {
        this.updateEventTriggersForGeneratedInstructions = true;
        return this;
    }

    public String getSourceProcessDefinitionId() {
        return this.sourceProcessDefinitionId;
    }

    public String getTargetProcessDefinitionId() {
        return this.targetProcessDefinitionId;
    }

    public boolean isMapEqualActivities() {
        return this.mapEqualActivities;
    }

    public VariableMap getVariables() {
        return this.variables;
    }

    public boolean isUpdateEventTriggersForGeneratedInstructions() {
        return this.updateEventTriggersForGeneratedInstructions;
    }

    public List<MigrationInstructionImpl> getExplicitMigrationInstructions() {
        return this.explicitMigrationInstructions;
    }

    @Override
    public MigrationPlan build() {
        return this.commandExecutor.execute(new CreateMigrationPlanCmd(this));
    }
}

