/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.batch;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.authorization.BatchPermissions;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.impl.batch.BatchConfiguration;
import io.openbpm.bpm.engine.impl.batch.DeploymentMapping;
import io.openbpm.bpm.engine.impl.batch.DeploymentMappings;
import io.openbpm.bpm.engine.impl.batch.builder.BatchBuilder;
import io.openbpm.bpm.engine.impl.core.variable.VariableUtil;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.migration.AbstractMigrationCmd;
import io.openbpm.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import io.openbpm.bpm.engine.impl.migration.batch.MigrationBatchConfiguration;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.migration.MigrationPlan;
import io.openbpm.bpm.engine.variable.VariableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class MigrateProcessInstanceBatchCmd
extends AbstractMigrationCmd
implements Command<Batch> {
    public MigrateProcessInstanceBatchCmd(MigrationPlanExecutionBuilderImpl builder) {
        super(builder);
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        Collection<String> collectedInstanceIds = this.collectProcessInstanceIds();
        MigrationPlan migrationPlan = this.executionBuilder.getMigrationPlan();
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Migration plan cannot be null", "migration plan", (Object)migrationPlan);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot empty", "process instance ids", collectedInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "process instance ids", collectedInstanceIds);
        ProcessDefinitionEntity sourceDefinition = this.resolveSourceProcessDefinition(commandContext);
        ProcessDefinitionEntity targetDefinition = this.resolveTargetProcessDefinition(commandContext);
        String tenantId = sourceDefinition.getTenantId();
        VariableMap variables = migrationPlan.getVariables();
        Batch batch = new BatchBuilder(commandContext).type("instance-migration").config(this.getConfiguration(collectedInstanceIds, sourceDefinition.getDeploymentId())).permission(BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES).permissionHandler(ctx -> this.checkAuthorizations(ctx, sourceDefinition, targetDefinition)).tenantId(tenantId).operationLogHandler((arg_0, arg_1) -> this.lambda$execute$1(sourceDefinition, targetDefinition, (Map)variables, arg_0, arg_1)).build();
        if (variables != null) {
            String batchId = batch.getId();
            VariableUtil.setVariablesByBatchId(variables, batchId);
        }
        return batch;
    }

    public BatchConfiguration getConfiguration(Collection<String> instanceIds, String deploymentId) {
        return new MigrationBatchConfiguration(new ArrayList<String>(instanceIds), DeploymentMappings.of(new DeploymentMapping(deploymentId, instanceIds.size())), this.executionBuilder.getMigrationPlan(), this.executionBuilder.isSkipCustomListeners(), this.executionBuilder.isSkipIoMappings());
    }

    private /* synthetic */ void lambda$execute$1(ProcessDefinitionEntity sourceDefinition, ProcessDefinitionEntity targetDefinition, Map variables, CommandContext ctx, int instanceCount) {
        this.writeUserOperationLog(ctx, sourceDefinition, targetDefinition, instanceCount, variables, true);
    }
}

