/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.jobexecutor.AsyncContinuationJobHandler;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingJobInstance;
import io.openbpm.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.pvm.PvmTransition;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.impl.pvm.process.TransitionImpl;
import io.openbpm.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import io.openbpm.bpm.engine.management.JobDefinition;
import java.util.List;

public class MigratingAsyncJobInstance
extends MigratingJobInstance {
    public MigratingAsyncJobInstance(JobEntity jobEntity, JobDefinitionEntity jobDefinitionEntity, ScopeImpl targetScope) {
        super(jobEntity, jobDefinitionEntity, targetScope);
    }

    @Override
    protected void migrateJobHandlerConfiguration() {
        AsyncContinuationJobHandler.AsyncContinuationConfiguration configuration = (AsyncContinuationJobHandler.AsyncContinuationConfiguration)this.jobEntity.getJobHandlerConfiguration();
        if (this.isAsyncAfter()) {
            this.updateAsyncAfterTargetConfiguration(configuration);
        } else {
            this.updateAsyncBeforeTargetConfiguration();
        }
    }

    public boolean isAsyncAfter() {
        JobDefinition jobDefinition = this.jobEntity.getJobDefinition();
        return "async-after".equals(jobDefinition.getJobConfiguration());
    }

    public boolean isAsyncBefore() {
        return !this.isAsyncAfter();
    }

    protected void updateAsyncBeforeTargetConfiguration() {
        AsyncContinuationJobHandler.AsyncContinuationConfiguration targetConfiguration = new AsyncContinuationJobHandler.AsyncContinuationConfiguration();
        AsyncContinuationJobHandler.AsyncContinuationConfiguration currentConfiguration = (AsyncContinuationJobHandler.AsyncContinuationConfiguration)this.jobEntity.getJobHandlerConfiguration();
        if (PvmAtomicOperation.PROCESS_START.getCanonicalName().equals(currentConfiguration.getAtomicOperation())) {
            targetConfiguration.setAtomicOperation(PvmAtomicOperation.PROCESS_START.getCanonicalName());
        } else if (((ActivityImpl)this.targetScope).getIncomingTransitions().isEmpty()) {
            targetConfiguration.setAtomicOperation(PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE.getCanonicalName());
        } else {
            targetConfiguration.setAtomicOperation(PvmAtomicOperation.TRANSITION_CREATE_SCOPE.getCanonicalName());
        }
        this.jobEntity.setJobHandlerConfiguration(targetConfiguration);
    }

    protected void updateAsyncAfterTargetConfiguration(AsyncContinuationJobHandler.AsyncContinuationConfiguration currentConfiguration) {
        ActivityImpl targetActivity = (ActivityImpl)this.targetScope;
        List<PvmTransition> outgoingTransitions = targetActivity.getOutgoingTransitions();
        AsyncContinuationJobHandler.AsyncContinuationConfiguration targetConfiguration = new AsyncContinuationJobHandler.AsyncContinuationConfiguration();
        if (outgoingTransitions.isEmpty()) {
            targetConfiguration.setAtomicOperation(PvmAtomicOperation.ACTIVITY_END.getCanonicalName());
        } else {
            targetConfiguration.setAtomicOperation(PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE.getCanonicalName());
            if (outgoingTransitions.size() == 1) {
                targetConfiguration.setTransitionId(outgoingTransitions.get(0).getId());
            } else {
                TransitionImpl matchingTargetTransition = null;
                String currentTransitionId = currentConfiguration.getTransitionId();
                if (currentTransitionId != null) {
                    matchingTargetTransition = targetActivity.findOutgoingTransition(currentTransitionId);
                }
                if (matchingTargetTransition != null) {
                    targetConfiguration.setTransitionId(matchingTargetTransition.getId());
                } else {
                    throw new ProcessEngineException("Cannot determine matching outgoing sequence flow");
                }
            }
        }
        this.jobEntity.setJobHandlerConfiguration(targetConfiguration);
    }
}

