/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.migration.MigrationLogger;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingCompensationEventSubscriptionInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.migration.MigrationInstruction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MigratingEventScopeInstance
extends MigratingScopeInstance {
    public static final MigrationLogger MIGRATION_LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected MigratingCompensationEventSubscriptionInstance migratingEventSubscription;
    protected ExecutionEntity eventScopeExecution;
    protected Set<MigratingEventScopeInstance> childInstances = new HashSet<MigratingEventScopeInstance>();
    protected Set<MigratingCompensationEventSubscriptionInstance> childCompensationSubscriptionInstances = new HashSet<MigratingCompensationEventSubscriptionInstance>();
    protected List<MigratingInstance> migratingDependentInstances = new ArrayList<MigratingInstance>();

    public MigratingEventScopeInstance(MigrationInstruction migrationInstruction, ExecutionEntity eventScopeExecution, ScopeImpl sourceScope, ScopeImpl targetScope, MigrationInstruction eventSubscriptionInstruction, EventSubscriptionEntity eventSubscription, ScopeImpl eventSubscriptionSourceScope, ScopeImpl eventSubscriptionTargetScope) {
        this.migratingEventSubscription = new MigratingCompensationEventSubscriptionInstance(eventSubscriptionInstruction, eventSubscriptionSourceScope, eventSubscriptionTargetScope, eventSubscription);
        this.migrationInstruction = migrationInstruction;
        this.eventScopeExecution = eventScopeExecution;
        this.sourceScope = sourceScope;
        this.targetScope = targetScope;
    }

    public MigratingEventScopeInstance(EventSubscriptionEntity eventSubscription, ExecutionEntity eventScopeExecution, ScopeImpl targetScope) {
        this.migratingEventSubscription = new MigratingCompensationEventSubscriptionInstance(null, null, targetScope, eventSubscription);
        this.eventScopeExecution = eventScopeExecution;
        this.targetScope = targetScope;
        this.currentScope = targetScope;
    }

    @Override
    public boolean isDetached() {
        return this.eventScopeExecution.getParentId() == null;
    }

    @Override
    public void detachState() {
        this.migratingEventSubscription.detachState();
        this.eventScopeExecution.setParent(null);
    }

    @Override
    public void attachState(MigratingScopeInstance targetActivityInstance) {
        this.setParent(targetActivityInstance);
        this.migratingEventSubscription.attachState(targetActivityInstance);
        ExecutionEntity representativeExecution = targetActivityInstance.resolveRepresentativeExecution();
        this.eventScopeExecution.setParent(representativeExecution);
    }

    @Override
    public void attachState(MigratingTransitionInstance targetTransitionInstance) {
        throw MIGRATION_LOGGER.cannotAttachToTransitionInstance(this);
    }

    @Override
    public void migrateState() {
        this.migratingEventSubscription.migrateState();
        this.eventScopeExecution.setActivity((ActivityImpl)this.targetScope);
        this.eventScopeExecution.setProcessDefinition(this.targetScope.getProcessDefinition());
        this.currentScope = this.targetScope;
    }

    @Override
    public void migrateDependentEntities() {
        for (MigratingInstance dependentEntity : this.migratingDependentInstances) {
            dependentEntity.migrateState();
        }
    }

    @Override
    public void setParent(MigratingScopeInstance parentInstance) {
        if (this.parentInstance != null) {
            this.parentInstance.removeChild(this);
        }
        this.parentInstance = parentInstance;
        if (parentInstance != null) {
            parentInstance.addChild(this);
        }
    }

    @Override
    public void addMigratingDependentInstance(MigratingInstance migratingInstance) {
        this.migratingDependentInstances.add(migratingInstance);
    }

    @Override
    public ExecutionEntity resolveRepresentativeExecution() {
        return this.eventScopeExecution;
    }

    @Override
    public void removeChild(MigratingScopeInstance migratingScopeInstance) {
        this.childInstances.remove(migratingScopeInstance);
    }

    @Override
    public void addChild(MigratingScopeInstance migratingScopeInstance) {
        if (!(migratingScopeInstance instanceof MigratingEventScopeInstance)) {
            throw MIGRATION_LOGGER.cannotHandleChild(this, migratingScopeInstance);
        }
        MigratingEventScopeInstance instance = (MigratingEventScopeInstance)migratingScopeInstance;
        this.childInstances.add(instance);
    }

    @Override
    public void addChild(MigratingCompensationEventSubscriptionInstance migratingEventSubscription) {
        this.childCompensationSubscriptionInstances.add(migratingEventSubscription);
    }

    @Override
    public void removeChild(MigratingCompensationEventSubscriptionInstance migratingEventSubscription) {
        this.childCompensationSubscriptionInstances.remove(migratingEventSubscription);
    }

    @Override
    public boolean migrates() {
        return this.targetScope != null;
    }

    @Override
    public void detachChildren() {
        HashSet<MigratingProcessElementInstance> childrenCopy = new HashSet<MigratingProcessElementInstance>(this.getChildren());
        for (MigratingProcessElementInstance child : childrenCopy) {
            child.detachState();
        }
    }

    @Override
    public void remove(boolean skipCustomListeners, boolean skipIoMappings) {
        this.eventScopeExecution.remove();
        this.migratingEventSubscription.remove();
        this.setParent(null);
    }

    @Override
    public Collection<MigratingProcessElementInstance> getChildren() {
        HashSet<MigratingProcessElementInstance> children = new HashSet<MigratingProcessElementInstance>(this.childInstances);
        children.addAll(this.childCompensationSubscriptionInstances);
        return children;
    }

    @Override
    public Collection<MigratingScopeInstance> getChildScopeInstances() {
        return new HashSet<MigratingScopeInstance>(this.childInstances);
    }

    @Override
    public void removeUnmappedDependentInstances() {
    }

    public MigratingCompensationEventSubscriptionInstance getEventSubscription() {
        return this.migratingEventSubscription;
    }
}

