/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.migration.MigrationLogger;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.repository.ProcessDefinition;
import java.util.ArrayList;
import java.util.List;

public class MigratingExternalTaskInstance
implements MigratingInstance {
    public static final MigrationLogger MIGRATION_LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected ExternalTaskEntity externalTask;
    protected MigratingActivityInstance migratingActivityInstance;
    protected List<MigratingInstance> dependentInstances = new ArrayList<MigratingInstance>();

    public MigratingExternalTaskInstance(ExternalTaskEntity externalTask, MigratingActivityInstance migratingActivityInstance) {
        this.externalTask = externalTask;
        this.migratingActivityInstance = migratingActivityInstance;
    }

    @Override
    public void migrateDependentEntities() {
        for (MigratingInstance migratingDependentInstance : this.dependentInstances) {
            migratingDependentInstance.migrateState();
        }
    }

    @Override
    public boolean isDetached() {
        return this.externalTask.getExecutionId() == null;
    }

    @Override
    public void detachState() {
        this.externalTask.getExecution().removeExternalTask(this.externalTask);
        this.externalTask.setExecution(null);
    }

    @Override
    public void attachState(MigratingScopeInstance owningInstance) {
        ExecutionEntity representativeExecution = owningInstance.resolveRepresentativeExecution();
        representativeExecution.addExternalTask(this.externalTask);
        this.externalTask.setExecution(representativeExecution);
    }

    @Override
    public void attachState(MigratingTransitionInstance targetTransitionInstance) {
        throw MIGRATION_LOGGER.cannotAttachToTransitionInstance(this);
    }

    @Override
    public void migrateState() {
        ScopeImpl targetActivity = this.migratingActivityInstance.getTargetScope();
        ProcessDefinition targetProcessDefinition = (ProcessDefinition)((Object)targetActivity.getProcessDefinition());
        this.externalTask.setActivityId(targetActivity.getId());
        this.externalTask.setProcessDefinitionId(targetProcessDefinition.getId());
        this.externalTask.setProcessDefinitionKey(targetProcessDefinition.getKey());
    }

    public String getId() {
        return this.externalTask.getId();
    }

    public ScopeImpl getTargetScope() {
        return this.migratingActivityInstance.getTargetScope();
    }

    public void addMigratingDependentInstance(MigratingInstance migratingInstance) {
        this.dependentInstances.add(migratingInstance);
    }
}

