/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance.parser;

import io.openbpm.bpm.engine.delegate.BaseDelegateExecution;
import io.openbpm.bpm.engine.impl.core.delegate.CoreActivityBehavior;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import io.openbpm.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import io.openbpm.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseHandler;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import io.openbpm.bpm.engine.impl.pvm.delegate.MigrationObserverBehavior;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.migration.MigrationInstruction;
import io.openbpm.bpm.engine.runtime.ActivityInstance;
import io.openbpm.bpm.engine.runtime.TransitionInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ActivityInstanceHandler
implements MigratingInstanceParseHandler<ActivityInstance> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, ActivityInstance element) {
        CoreActivityBehavior<? extends BaseDelegateExecution> sourceActivityBehavior;
        MigratingActivityInstance migratingInstance = null;
        MigrationInstruction applyingInstruction = parseContext.getInstructionFor(element.getActivityId());
        ScopeImpl sourceScope = null;
        ScopeImpl targetScope = null;
        ExecutionEntity representativeExecution = parseContext.getMapping().getExecution(element);
        if (element.getId().equals(element.getProcessInstanceId())) {
            sourceScope = parseContext.getSourceProcessDefinition();
            targetScope = parseContext.getTargetProcessDefinition();
        } else {
            sourceScope = parseContext.getSourceProcessDefinition().findActivity(element.getActivityId());
            if (applyingInstruction != null) {
                String activityId = applyingInstruction.getTargetActivityId();
                targetScope = parseContext.getTargetProcessDefinition().findActivity(activityId);
            }
        }
        migratingInstance = parseContext.getMigratingProcessInstance().addActivityInstance(applyingInstruction, element, sourceScope, targetScope, representativeExecution);
        MigratingActivityInstance parentInstance = parseContext.getMigratingActivityInstanceById(element.getParentActivityInstanceId());
        if (parentInstance != null) {
            migratingInstance.setParent(parentInstance);
        }
        if ((sourceActivityBehavior = sourceScope.getActivityBehavior()) instanceof MigrationObserverBehavior) {
            MigrationObserverBehavior migrationObserverBehavior = (MigrationObserverBehavior)((Object)sourceActivityBehavior);
            migrationObserverBehavior.onParseMigratingInstance(parseContext, migratingInstance);
        }
        parseContext.submit(migratingInstance);
        this.parseTransitionInstances(parseContext, migratingInstance);
        this.parseDependentInstances(parseContext, migratingInstance);
    }

    public void parseTransitionInstances(MigratingInstanceParseContext parseContext, MigratingActivityInstance migratingInstance) {
        for (TransitionInstance transitionInstance : migratingInstance.getActivityInstance().getChildTransitionInstances()) {
            parseContext.handleTransitionInstance(transitionInstance);
        }
    }

    public void parseDependentInstances(MigratingInstanceParseContext parseContext, MigratingActivityInstance migratingInstance) {
        parseContext.handleDependentVariables(migratingInstance, this.collectActivityInstanceVariables(migratingInstance));
        parseContext.handleDependentActivityInstanceJobs(migratingInstance, this.collectActivityInstanceJobs(migratingInstance));
        parseContext.handleDependentEventSubscriptions(migratingInstance, this.collectActivityInstanceEventSubscriptions(migratingInstance));
    }

    protected List<VariableInstanceEntity> collectActivityInstanceVariables(MigratingActivityInstance instance) {
        boolean addAnyParentExecutionVariables;
        boolean addAllRepresentativeExecutionVariables;
        ArrayList<VariableInstanceEntity> variables = new ArrayList<VariableInstanceEntity>();
        ExecutionEntity representativeExecution = instance.resolveRepresentativeExecution();
        ExecutionEntity parentExecution = representativeExecution.getParent();
        boolean bl = addAllRepresentativeExecutionVariables = instance.getSourceScope().isScope() || representativeExecution.isConcurrent();
        if (addAllRepresentativeExecutionVariables) {
            variables.addAll(representativeExecution.getVariablesInternal());
        } else {
            variables.addAll(ActivityInstanceHandler.getConcurrentLocalVariables(representativeExecution));
        }
        boolean bl2 = addAnyParentExecutionVariables = parentExecution != null && instance.getSourceScope().isScope();
        if (addAnyParentExecutionVariables) {
            boolean addAllParentExecutionVariables = parentExecution.isConcurrent();
            if (addAllParentExecutionVariables) {
                variables.addAll(parentExecution.getVariablesInternal());
            } else {
                variables.addAll(ActivityInstanceHandler.getConcurrentLocalVariables(parentExecution));
            }
        }
        return variables;
    }

    protected List<EventSubscriptionEntity> collectActivityInstanceEventSubscriptions(MigratingActivityInstance migratingInstance) {
        if (migratingInstance.getSourceScope().isScope()) {
            return migratingInstance.resolveRepresentativeExecution().getEventSubscriptions();
        }
        return Collections.emptyList();
    }

    protected List<JobEntity> collectActivityInstanceJobs(MigratingActivityInstance migratingInstance) {
        if (migratingInstance.getSourceScope().isScope()) {
            return migratingInstance.resolveRepresentativeExecution().getJobs();
        }
        return Collections.emptyList();
    }

    public static List<VariableInstanceEntity> getConcurrentLocalVariables(ExecutionEntity execution) {
        ArrayList<VariableInstanceEntity> variables = new ArrayList<VariableInstanceEntity>();
        for (VariableInstanceEntity variable : execution.getVariablesInternal()) {
            if (!variable.isConcurrentLocal()) continue;
            variables.add(variable);
        }
        return variables;
    }
}

