/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance.parser;

import io.openbpm.bpm.engine.impl.migration.instance.MigratingAsyncJobInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import io.openbpm.bpm.engine.impl.migration.instance.parser.MigratingDependentInstanceParseHandler;
import io.openbpm.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import io.openbpm.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import java.util.List;

public class TransitionInstanceJobHandler
implements MigratingDependentInstanceParseHandler<MigratingTransitionInstance, List<JobEntity>> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, MigratingTransitionInstance transitionInstance, List<JobEntity> elements) {
        for (JobEntity job : elements) {
            if (!TransitionInstanceJobHandler.isAsyncContinuation(job)) continue;
            ScopeImpl targetScope = transitionInstance.getTargetScope();
            if (targetScope != null) {
                JobDefinitionEntity targetJobDefinitionEntity = parseContext.getTargetJobDefinition(transitionInstance.getTargetScope().getId(), job.getJobHandlerType());
                MigratingAsyncJobInstance migratingJobInstance = new MigratingAsyncJobInstance(job, targetJobDefinitionEntity, transitionInstance.getTargetScope());
                transitionInstance.setDependentJobInstance(migratingJobInstance);
                parseContext.submit(migratingJobInstance);
            }
            parseContext.consume(job);
        }
    }

    protected static boolean isAsyncContinuation(JobEntity job) {
        return job != null && "async-continuation".equals(job.getJobHandlerType());
    }
}

