/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.validation.instance;

import io.openbpm.bpm.engine.impl.jobexecutor.AsyncContinuationJobHandler;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingJobInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import io.openbpm.bpm.engine.impl.migration.validation.instance.MigratingTransitionInstanceValidationReportImpl;
import io.openbpm.bpm.engine.impl.migration.validation.instance.MigratingTransitionInstanceValidator;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.process.TransitionImpl;

public class AsyncAfterMigrationValidator
implements MigratingTransitionInstanceValidator {
    @Override
    public void validate(MigratingTransitionInstance migratingInstance, MigratingProcessInstance migratingProcessInstance, MigratingTransitionInstanceValidationReportImpl instanceReport) {
        ActivityImpl targetActivity = (ActivityImpl)migratingInstance.getTargetScope();
        if (targetActivity != null && migratingInstance.isAsyncAfter()) {
            MigratingJobInstance jobInstance = migratingInstance.getJobInstance();
            AsyncContinuationJobHandler.AsyncContinuationConfiguration config = (AsyncContinuationJobHandler.AsyncContinuationConfiguration)jobInstance.getJobEntity().getJobHandlerConfiguration();
            String sourceTransitionId = config.getTransitionId();
            if (targetActivity.getOutgoingTransitions().size() > 1) {
                if (sourceTransitionId == null) {
                    instanceReport.addFailure("Transition instance is assigned to no sequence flow and target activity has more than one outgoing sequence flow");
                } else {
                    TransitionImpl matchingOutgoingTransition = targetActivity.findOutgoingTransition(sourceTransitionId);
                    if (matchingOutgoingTransition == null) {
                        instanceReport.addFailure("Transition instance is assigned to a sequence flow that cannot be matched in the target activity");
                    }
                }
            }
        }
    }
}

