/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.validation.instruction;

import io.openbpm.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import io.openbpm.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import io.openbpm.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import io.openbpm.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import io.openbpm.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.impl.tree.FlowScopeWalker;
import io.openbpm.bpm.engine.impl.tree.TreeVisitor;

public class CannotAddMultiInstanceBodyValidator
implements MigrationInstructionValidator {
    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ActivityImpl targetActivity = instruction.getTargetActivity();
        FlowScopeWalker flowScopeWalker = new FlowScopeWalker(targetActivity.getFlowScope());
        MiBodyCollector miBodyCollector = new MiBodyCollector();
        flowScopeWalker.addPreVisitor(miBodyCollector);
        flowScopeWalker.walkWhile(element -> element == null || !instructions.getInstructionsByTargetScope((ScopeImpl)element).isEmpty());
        if (miBodyCollector.firstMiBody != null) {
            report.addFailure("Target activity '" + targetActivity.getId() + "' is a descendant of multi-instance body '" + miBodyCollector.firstMiBody.getId() + "' that is not mapped from the source process definition.");
        }
    }

    public static class MiBodyCollector
    implements TreeVisitor<ScopeImpl> {
        protected ScopeImpl firstMiBody;

        @Override
        public void visit(ScopeImpl obj) {
            if (this.firstMiBody == null && obj != null && this.isMiBody(obj)) {
                this.firstMiBody = obj;
            }
        }

        protected boolean isMiBody(ScopeImpl scope) {
            return scope.getActivityBehavior() instanceof MultiInstanceActivityBehavior;
        }
    }
}

