/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.validation.instruction;

import io.openbpm.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import io.openbpm.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import io.openbpm.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import io.openbpm.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.util.StringUtil;
import java.util.List;

public class OnlyOnceMappedActivityInstructionValidator
implements MigrationInstructionValidator {
    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ActivityImpl sourceActivity = instruction.getSourceActivity();
        List<ValidatingMigrationInstruction> instructionsForSourceActivity = instructions.getInstructionsBySourceScope(sourceActivity);
        if (instructionsForSourceActivity.size() > 1) {
            this.addFailure(sourceActivity.getId(), instructionsForSourceActivity, report);
        }
    }

    protected void addFailure(String sourceActivityId, List<ValidatingMigrationInstruction> migrationInstructions, MigrationInstructionValidationReportImpl report) {
        report.addFailure("There are multiple mappings for source activity id '" + sourceActivityId + "': " + StringUtil.join(new StringUtil.StringIterator<ValidatingMigrationInstruction>(migrationInstructions.iterator()){

            @Override
            public String next() {
                return ((ValidatingMigrationInstruction)this.iterator.next()).toString();
            }
        }));
    }
}

