/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.optimize;

import io.openbpm.bpm.engine.authorization.Permissions;
import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.history.HistoricActivityInstance;
import io.openbpm.bpm.engine.history.HistoricDecisionInstance;
import io.openbpm.bpm.engine.history.HistoricProcessInstance;
import io.openbpm.bpm.engine.history.HistoricTaskInstance;
import io.openbpm.bpm.engine.history.HistoricVariableUpdate;
import io.openbpm.bpm.engine.history.UserOperationLogEntry;
import io.openbpm.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.db.CompositePermissionCheck;
import io.openbpm.bpm.engine.impl.db.PermissionCheckBuilder;
import io.openbpm.bpm.engine.impl.persistence.AbstractManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.optimize.OptimizeHistoricIdentityLinkLogEntity;
import io.openbpm.commons.utils.CollectionUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class OptimizeManager
extends AbstractManager {
    private static final String CREATED_AFTER = "createdAfter";
    private static final String CREATED_AT = "createdAt";
    private static final String EVALUATED_AFTER = "evaluatedAfter";
    private static final String EVALUATED_AT = "evaluatedAt";
    private static final String FINISHED_AFTER = "finishedAfter";
    private static final String FINISHED_AT = "finishedAt";
    private static final String OCCURRED_AFTER = "occurredAfter";
    private static final String OCCURRED_AT = "occurredAt";
    private static final String OPERATION_TYPES = "operationTypes";
    private static final String STARTED_AFTER = "startedAfter";
    private static final String STARTED_AT = "startedAt";

    public void fetchHistoricVariableUpdateByteArrays(List<String> byteArrayIds) {
        List partitions = CollectionUtil.partition(byteArrayIds, (int)2000);
        for (List partition : partitions) {
            this.getDbEntityManager().selectList("selectByteArrays", partition);
        }
    }

    public List<HistoricActivityInstance> getCompletedHistoricActivityInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put(FINISHED_AFTER, finishedAfter);
        params.put(FINISHED_AT, finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricActivityPage", params);
    }

    public List<HistoricActivityInstance> getRunningHistoricActivityInstances(Date startedAfter, Date startedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put(STARTED_AFTER, startedAfter);
        params.put(STARTED_AT, startedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectRunningHistoricActivityPage", params);
    }

    public List<HistoricTaskInstance> getCompletedHistoricTaskInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put(FINISHED_AFTER, finishedAfter);
        params.put(FINISHED_AT, finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricTaskInstancePage", params);
    }

    public List<HistoricTaskInstance> getRunningHistoricTaskInstances(Date startedAfter, Date startedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put(STARTED_AFTER, startedAfter);
        params.put(STARTED_AT, startedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectRunningHistoricTaskInstancePage", params);
    }

    public List<UserOperationLogEntry> getHistoricUserOperationLogs(Date occurredAfter, Date occurredAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        String[] operationTypes = new String[]{"SuspendJob", "ActivateJob", "SuspendProcessDefinition", "ActivateProcessDefinition", "Suspend", "Activate"};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(OCCURRED_AFTER, occurredAfter);
        params.put(OCCURRED_AT, occurredAt);
        params.put(OPERATION_TYPES, operationTypes);
        params.put("maxResults", maxResults);
        return this.getDbEntityManager().selectList("selectHistoricUserOperationLogPage", params);
    }

    public List<OptimizeHistoricIdentityLinkLogEntity> getHistoricIdentityLinkLogs(Date occurredAfter, Date occurredAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put(OCCURRED_AFTER, occurredAfter);
        params.put(OCCURRED_AT, occurredAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectHistoricIdentityLinkPage", params);
    }

    public List<HistoricProcessInstance> getCompletedHistoricProcessInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put(FINISHED_AFTER, finishedAfter);
        params.put(FINISHED_AT, finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricProcessInstancePage", params);
    }

    public List<HistoricProcessInstance> getRunningHistoricProcessInstances(Date startedAfter, Date startedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put(STARTED_AFTER, startedAfter);
        params.put(STARTED_AT, startedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectRunningHistoricProcessInstancePage", params);
    }

    public List<HistoricVariableUpdate> getHistoricVariableUpdates(Date occurredAfter, Date occurredAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put(OCCURRED_AFTER, occurredAfter);
        params.put(OCCURRED_AT, occurredAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectHistoricVariableUpdatePage", params);
    }

    public List<HistoricIncidentEntity> getCompletedHistoricIncidents(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put(FINISHED_AFTER, finishedAfter);
        params.put(FINISHED_AT, finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricIncidentsPage", params);
    }

    public List<HistoricIncidentEntity> getOpenHistoricIncidents(Date createdAfter, Date createdAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put(CREATED_AFTER, createdAfter);
        params.put(CREATED_AT, createdAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectOpenHistoricIncidentsPage", params);
    }

    public List<HistoricDecisionInstance> getHistoricDecisionInstances(Date evaluatedAfter, Date evaluatedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put(EVALUATED_AFTER, evaluatedAfter);
        params.put(EVALUATED_AT, evaluatedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        List decisionInstances = this.getDbEntityManager().selectList("selectHistoricDecisionInstancePage", params);
        HistoricDecisionInstanceQueryImpl query = (HistoricDecisionInstanceQueryImpl)new HistoricDecisionInstanceQueryImpl().disableBinaryFetching().disableCustomObjectDeserialization().includeInputs().includeOutputs();
        List partitions = CollectionUtil.partition((List)decisionInstances, (int)2000);
        for (List partition : partitions) {
            this.getHistoricDecisionInstanceManager().enrichHistoricDecisionsWithInputsAndOutputs(query, partition);
        }
        return decisionInstances;
    }

    private void checkIsAuthorizedToReadHistoryAndTenants() {
        CompositePermissionCheck necessaryPermissionsForOptimize = new PermissionCheckBuilder().conjunctive().atomicCheckForResourceId(Resources.PROCESS_DEFINITION, "*", Permissions.READ_HISTORY).atomicCheckForResourceId(Resources.DECISION_DEFINITION, "*", Permissions.READ_HISTORY).atomicCheckForResourceId(Resources.TENANT, "*", Permissions.READ).build();
        this.getAuthorizationManager().checkAuthorization(necessaryPermissionsForOptimize);
    }
}

