/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence;

import io.openbpm.bpm.engine.authorization.Permission;
import io.openbpm.bpm.engine.authorization.Resource;
import io.openbpm.bpm.engine.impl.AbstractQuery;
import io.openbpm.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import io.openbpm.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionManager;
import io.openbpm.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionManager;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.DbEntity;
import io.openbpm.bpm.engine.impl.db.entitymanager.DbEntityManager;
import io.openbpm.bpm.engine.impl.db.sql.DbSqlSession;
import io.openbpm.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionManager;
import io.openbpm.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionManager;
import io.openbpm.bpm.engine.impl.form.entity.OperatonFormDefinitionManager;
import io.openbpm.bpm.engine.impl.history.event.HistoricDecisionInstanceManager;
import io.openbpm.bpm.engine.impl.identity.Authentication;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.Session;
import io.openbpm.bpm.engine.impl.persistence.entity.AttachmentManager;
import io.openbpm.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.AuthorizationManager;
import io.openbpm.bpm.engine.impl.persistence.entity.BatchManager;
import io.openbpm.bpm.engine.impl.persistence.entity.ByteArrayManager;
import io.openbpm.bpm.engine.impl.persistence.entity.DeploymentManager;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricActivityInstanceManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricBatchManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricCaseActivityInstanceManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricCaseInstanceManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricDetailManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricExternalTaskLogManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricIdentityLinkLogManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricIncidentManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricJobLogManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricProcessInstanceManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricTaskInstanceManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricVariableInstanceManager;
import io.openbpm.bpm.engine.impl.persistence.entity.IdentityInfoManager;
import io.openbpm.bpm.engine.impl.persistence.entity.IdentityLinkManager;
import io.openbpm.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import io.openbpm.bpm.engine.impl.persistence.entity.JobManager;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import io.openbpm.bpm.engine.impl.persistence.entity.ReportManager;
import io.openbpm.bpm.engine.impl.persistence.entity.ResourceManager;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskManager;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskReportManager;
import io.openbpm.bpm.engine.impl.persistence.entity.TenantManager;
import io.openbpm.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceManager;

public abstract class AbstractManager
implements Session {
    protected static final String ACTIVITY_ID = "activityId";
    protected static final String BATCH_ID = "batchId";
    protected static final String BATCH_SIZE = "batchSize";
    protected static final String CASE_INSTANCE_IDS = "caseInstanceIds";
    protected static final String CURRENT_TIMESTAMP = "currentTimestamp";
    protected static final String ID = "id";
    protected static final String IS_PROCESS_DEFINITION_TENANT_ID_SET = "isProcessDefinitionTenantIdSet";
    protected static final String IS_TENANT_ID_SET = "isTenantIdSet";
    protected static final String JOB_DEFINITION_ID = "jobDefinitionId";
    protected static final String MAX_RESULTS = "maxResults";
    protected static final String MINUTE_FROM = "minuteFrom";
    protected static final String MINUTE_TO = "minuteTo";
    protected static final String REMOVAL_TIME = "removalTime";
    protected static final String PROCESS_DEFINITION_ID = "processDefinitionId";
    protected static final String PROCESS_DEFINITION_KEY = "processDefinitionKey";
    protected static final String PROCESS_DEFINITION_TENANT_ID = "processDefinitionTenantId";
    protected static final String PROCESS_INSTANCE_ID = "processInstanceId";
    protected static final String PROCESS_INSTANCE_IDS = "processInstanceIds";
    protected static final String ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    protected static final String SUSPENSION_STATE = "suspensionState";
    protected static final String TASK_CASE_INSTANCE_IDS = "taskCaseInstanceIds";
    protected static final String TASK_ID = "taskId";
    protected static final String TASK_PROCESS_INSTANCE_IDS = "taskProcessInstanceIds";
    protected static final String TENANT_ID = "tenantId";

    public void insert(DbEntity dbEntity) {
        this.getDbEntityManager().insert(dbEntity);
    }

    public void delete(DbEntity dbEntity) {
        this.getDbEntityManager().delete(dbEntity);
    }

    protected DbEntityManager getDbEntityManager() {
        return this.getSession(DbEntityManager.class);
    }

    protected DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    protected <T> T getSession(Class<T> sessionClass) {
        return Context.getCommandContext().getSession(sessionClass);
    }

    protected DeploymentManager getDeploymentManager() {
        return this.getSession(DeploymentManager.class);
    }

    protected ResourceManager getResourceManager() {
        return this.getSession(ResourceManager.class);
    }

    protected ByteArrayManager getByteArrayManager() {
        return this.getSession(ByteArrayManager.class);
    }

    protected ProcessDefinitionManager getProcessDefinitionManager() {
        return this.getSession(ProcessDefinitionManager.class);
    }

    protected CaseDefinitionManager getCaseDefinitionManager() {
        return this.getSession(CaseDefinitionManager.class);
    }

    protected DecisionDefinitionManager getDecisionDefinitionManager() {
        return this.getSession(DecisionDefinitionManager.class);
    }

    protected DecisionRequirementsDefinitionManager getDecisionRequirementsDefinitionManager() {
        return this.getSession(DecisionRequirementsDefinitionManager.class);
    }

    protected OperatonFormDefinitionManager getOperatonFormDefinitionManager() {
        return this.getSession(OperatonFormDefinitionManager.class);
    }

    protected HistoricDecisionInstanceManager getHistoricDecisionInstanceManager() {
        return this.getSession(HistoricDecisionInstanceManager.class);
    }

    protected CaseExecutionManager getCaseInstanceManager() {
        return this.getSession(CaseExecutionManager.class);
    }

    protected CaseExecutionManager getCaseExecutionManager() {
        return this.getSession(CaseExecutionManager.class);
    }

    protected ExecutionManager getProcessInstanceManager() {
        return this.getSession(ExecutionManager.class);
    }

    protected TaskManager getTaskManager() {
        return this.getSession(TaskManager.class);
    }

    protected TaskReportManager getTaskReportManager() {
        return this.getSession(TaskReportManager.class);
    }

    protected IdentityLinkManager getIdentityLinkManager() {
        return this.getSession(IdentityLinkManager.class);
    }

    protected VariableInstanceManager getVariableInstanceManager() {
        return this.getSession(VariableInstanceManager.class);
    }

    protected HistoricProcessInstanceManager getHistoricProcessInstanceManager() {
        return this.getSession(HistoricProcessInstanceManager.class);
    }

    protected HistoricCaseInstanceManager getHistoricCaseInstanceManager() {
        return this.getSession(HistoricCaseInstanceManager.class);
    }

    protected HistoricDetailManager getHistoricDetailManager() {
        return this.getSession(HistoricDetailManager.class);
    }

    protected HistoricVariableInstanceManager getHistoricVariableInstanceManager() {
        return this.getSession(HistoricVariableInstanceManager.class);
    }

    protected HistoricActivityInstanceManager getHistoricActivityInstanceManager() {
        return this.getSession(HistoricActivityInstanceManager.class);
    }

    protected HistoricCaseActivityInstanceManager getHistoricCaseActivityInstanceManager() {
        return this.getSession(HistoricCaseActivityInstanceManager.class);
    }

    protected HistoricTaskInstanceManager getHistoricTaskInstanceManager() {
        return this.getSession(HistoricTaskInstanceManager.class);
    }

    protected HistoricIncidentManager getHistoricIncidentManager() {
        return this.getSession(HistoricIncidentManager.class);
    }

    protected HistoricIdentityLinkLogManager getHistoricIdentityLinkManager() {
        return this.getSession(HistoricIdentityLinkLogManager.class);
    }

    protected HistoricJobLogManager getHistoricJobLogManager() {
        return this.getSession(HistoricJobLogManager.class);
    }

    protected HistoricExternalTaskLogManager getHistoricExternalTaskLogManager() {
        return this.getSession(HistoricExternalTaskLogManager.class);
    }

    protected JobManager getJobManager() {
        return this.getSession(JobManager.class);
    }

    protected JobDefinitionManager getJobDefinitionManager() {
        return this.getSession(JobDefinitionManager.class);
    }

    protected UserOperationLogManager getUserOperationLogManager() {
        return this.getSession(UserOperationLogManager.class);
    }

    protected EventSubscriptionManager getEventSubscriptionManager() {
        return this.getSession(EventSubscriptionManager.class);
    }

    protected IdentityInfoManager getIdentityInfoManager() {
        return this.getSession(IdentityInfoManager.class);
    }

    protected AttachmentManager getAttachmentManager() {
        return this.getSession(AttachmentManager.class);
    }

    protected ReportManager getHistoricReportManager() {
        return this.getSession(ReportManager.class);
    }

    protected BatchManager getBatchManager() {
        return this.getSession(BatchManager.class);
    }

    protected HistoricBatchManager getHistoricBatchManager() {
        return this.getSession(HistoricBatchManager.class);
    }

    protected TenantManager getTenantManager() {
        return this.getSession(TenantManager.class);
    }

    protected CommandContext getCommandContext() {
        return Context.getCommandContext();
    }

    protected AuthorizationManager getAuthorizationManager() {
        return this.getSession(AuthorizationManager.class);
    }

    protected void configureQuery(AbstractQuery<?, ?> query, Resource resource) {
        this.getAuthorizationManager().configureQuery((AbstractQuery)query, resource);
    }

    protected void checkAuthorization(Permission permission, Resource resource, String resourceId) {
        this.getAuthorizationManager().checkAuthorization(permission, resource, resourceId);
    }

    public boolean isAuthorizationEnabled() {
        return Context.getProcessEngineConfiguration().isAuthorizationEnabled();
    }

    protected Authentication getCurrentAuthentication() {
        return Context.getCommandContext().getAuthentication();
    }

    protected ResourceAuthorizationProvider getResourceAuthorizationProvider() {
        return Context.getProcessEngineConfiguration().getResourceAuthorizationProvider();
    }

    protected void deleteAuthorizations(Resource resource, String resourceId) {
        this.getAuthorizationManager().deleteAuthorizationsByResourceId(resource, resourceId);
    }

    protected void deleteAuthorizationsForUser(Resource resource, String resourceId, String userId) {
        this.getAuthorizationManager().deleteAuthorizationsByResourceIdAndUserId(resource, resourceId, userId);
    }

    protected void deleteAuthorizationsForGroup(Resource resource, String resourceId, String groupId) {
        this.getAuthorizationManager().deleteAuthorizationsByResourceIdAndGroupId(resource, resourceId, groupId);
    }

    public void saveDefaultAuthorizations(AuthorizationEntity[] authorizations) {
        if (authorizations != null && authorizations.length > 0) {
            Context.getCommandContext().runWithoutAuthorization(() -> {
                AuthorizationManager authorizationManager = this.getAuthorizationManager();
                for (AuthorizationEntity authorization : authorizations) {
                    if (authorization.getId() == null) {
                        authorizationManager.insert(authorization);
                        continue;
                    }
                    authorizationManager.update(authorization);
                }
                return null;
            });
        }
    }

    public void deleteDefaultAuthorizations(AuthorizationEntity[] authorizations) {
        if (authorizations != null && authorizations.length > 0) {
            Context.getCommandContext().runWithoutAuthorization(() -> {
                AuthorizationManager authorizationManager = this.getAuthorizationManager();
                for (AuthorizationEntity authorization : authorizations) {
                    authorizationManager.delete(authorization);
                }
                return null;
            });
        }
    }
}

