/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.deploy.cache;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.EnginePersistenceLogger;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import io.openbpm.bpm.engine.impl.repository.ResourceDefinitionEntity;
import io.openbpm.bpm.engine.repository.ResourceDefinition;
import io.openbpm.bpm.model.xml.ModelInstance;
import io.openbpm.commons.utils.cache.Cache;
import java.io.InputStream;
import java.util.List;

public abstract class ModelInstanceCache<INSTANCE_TYPE extends ModelInstance, DEFINITION_TYPE extends ResourceDefinitionEntity> {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected Cache<String, INSTANCE_TYPE> instanceCache;
    protected ResourceDefinitionCache<DEFINITION_TYPE> definitionCache;

    protected ModelInstanceCache(CacheFactory factory, int cacheCapacity, ResourceDefinitionCache<DEFINITION_TYPE> definitionCache) {
        this.instanceCache = factory.createCache(cacheCapacity);
        this.definitionCache = definitionCache;
    }

    public INSTANCE_TYPE findBpmnModelInstanceForDefinition(DEFINITION_TYPE definitionEntity) {
        Object bpmnModelInstance = (ModelInstance)this.instanceCache.get((Object)definitionEntity.getId());
        if (bpmnModelInstance == null) {
            bpmnModelInstance = this.loadAndCacheBpmnModelInstance(definitionEntity);
        }
        return (INSTANCE_TYPE)bpmnModelInstance;
    }

    public INSTANCE_TYPE findBpmnModelInstanceForDefinition(String definitionId) {
        Object bpmnModelInstance = (ModelInstance)this.instanceCache.get((Object)definitionId);
        if (bpmnModelInstance == null) {
            DEFINITION_TYPE definition = this.definitionCache.findDeployedDefinitionById(definitionId);
            bpmnModelInstance = this.loadAndCacheBpmnModelInstance(definition);
        }
        return (INSTANCE_TYPE)bpmnModelInstance;
    }

    protected INSTANCE_TYPE loadAndCacheBpmnModelInstance(DEFINITION_TYPE definitionEntity) {
        CommandContext commandContext = Context.getCommandContext();
        InputStream bpmnResourceInputStream = commandContext.runWithoutAuthorization(new GetDeploymentResourceCmd(definitionEntity.getDeploymentId(), definitionEntity.getResourceName()));
        try {
            INSTANCE_TYPE bpmnModelInstance = this.readModelFromStream(bpmnResourceInputStream);
            this.instanceCache.put((Object)definitionEntity.getId(), bpmnModelInstance);
            return bpmnModelInstance;
        }
        catch (Exception e) {
            this.throwLoadModelException(definitionEntity.getId(), e);
            return null;
        }
    }

    public void removeAllDefinitionsByDeploymentId(String deploymentId) {
        List<ResourceDefinition> allDefinitionsForDeployment = this.getAllDefinitionsForDeployment(deploymentId);
        for (ResourceDefinition definition : allDefinitionsForDeployment) {
            try {
                this.instanceCache.remove((Object)definition.getId());
                this.definitionCache.removeDefinitionFromCache(definition.getId());
            }
            catch (Exception e) {
                this.logRemoveEntryFromDeploymentCacheFailure(definition.getId(), e);
            }
        }
    }

    public void remove(String definitionId) {
        this.instanceCache.remove((Object)definitionId);
    }

    public void clear() {
        this.instanceCache.clear();
    }

    public Cache<String, INSTANCE_TYPE> getCache() {
        return this.instanceCache;
    }

    protected abstract void throwLoadModelException(String var1, Exception var2);

    protected abstract void logRemoveEntryFromDeploymentCacheFailure(String var1, Exception var2);

    protected abstract INSTANCE_TYPE readModelFromStream(InputStream var1);

    protected abstract List<? extends ResourceDefinition> getAllDefinitionsForDeployment(String var1);
}

