/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.deploy.cache;

import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.CacheDeployer;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import io.openbpm.bpm.engine.impl.persistence.entity.OperatonFormDefinitionEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class OperatonFormDefinitionCache
extends ResourceDefinitionCache<OperatonFormDefinitionEntity> {
    private static final String VAR_OPERATON_FORM_DEFINITION = "operatonFormDefinition";
    private static final String VAR_OPERATON_FORM_DEFINITION_ID = "operatonFormDefinitionId";
    private static final String VAR_CACHED_PROCESS_DEFINITION = "cachedProcessDefinition";

    public OperatonFormDefinitionCache(CacheFactory factory, int cacheCapacity, CacheDeployer cacheDeployer) {
        super(factory, cacheCapacity, cacheDeployer);
    }

    @Override
    protected AbstractResourceDefinitionManager<OperatonFormDefinitionEntity> getManager() {
        return Context.getCommandContext().getOperatonFormDefinitionManager();
    }

    @Override
    protected void checkInvalidDefinitionId(String definitionId) {
        EnsureUtil.ensureNotNull("Invalid operaton form definition id", VAR_OPERATON_FORM_DEFINITION_ID, (Object)definitionId);
    }

    @Override
    protected void checkDefinitionFound(String definitionId, OperatonFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed operaton form definition found with id '" + definitionId + "'", VAR_OPERATON_FORM_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKey(String definitionKey, OperatonFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed operaton form definition found with key '" + definitionKey + "'", VAR_OPERATON_FORM_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyAndTenantId(String definitionKey, String tenantId, OperatonFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed operaton form definition found with key '" + definitionKey + "' and tenant-id '" + tenantId + "'", VAR_OPERATON_FORM_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId, OperatonFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed operaton form definition found with key '" + definitionKey + "', version '" + definitionVersion + "' and tenant-id '" + tenantId + "'", VAR_OPERATON_FORM_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionTagAndTenantId(String definitionKey, String definitionVersionTag, String tenantId, OperatonFormDefinitionEntity definition) {
    }

    @Override
    protected void checkInvalidDefinitionByDeploymentAndKey(String deploymentId, String definitionKey, OperatonFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("no deployed operaton form definition found with key '" + definitionKey + "' in deployment '" + deploymentId + "'", VAR_OPERATON_FORM_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionWasCached(String deploymentId, String definitionId, OperatonFormDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put operaton form definition '" + definitionId + "' in the cache", VAR_CACHED_PROCESS_DEFINITION, (Object)definition);
    }
}

