/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.entity;

import io.openbpm.bpm.engine.impl.persistence.entity.ProcessElementInstanceImpl;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.runtime.ActivityInstance;
import io.openbpm.bpm.engine.runtime.Incident;
import io.openbpm.bpm.engine.runtime.ProcessElementInstance;
import io.openbpm.bpm.engine.runtime.TransitionInstance;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class ActivityInstanceImpl
extends ProcessElementInstanceImpl
implements ActivityInstance {
    protected static final ActivityInstance[] NO_ACTIVITY_INSTANCES = new ActivityInstance[0];
    protected static final TransitionInstance[] NO_TRANSITION_INSTANCES = new TransitionInstance[0];
    protected String businessKey;
    protected String activityId;
    protected String activityName;
    protected String activityType;
    protected String subProcessInstanceId;
    protected ActivityInstance[] childActivityInstances = NO_ACTIVITY_INSTANCES;
    protected TransitionInstance[] childTransitionInstances = NO_TRANSITION_INSTANCES;
    protected String[] executionIds = NO_IDS;
    protected String[] incidentIds = NO_IDS;
    protected Incident[] incidents = new Incident[0];

    @Override
    public ActivityInstance[] getChildActivityInstances() {
        return this.childActivityInstances;
    }

    public void setChildActivityInstances(ActivityInstance[] childInstances) {
        this.childActivityInstances = childInstances;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public String[] getExecutionIds() {
        return this.executionIds;
    }

    public void setExecutionIds(String[] executionIds) {
        this.executionIds = executionIds;
    }

    @Override
    public TransitionInstance[] getChildTransitionInstances() {
        return this.childTransitionInstances;
    }

    public void setChildTransitionInstances(TransitionInstance[] childTransitionInstances) {
        this.childTransitionInstances = childTransitionInstances;
    }

    @Override
    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    @Override
    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    @Override
    public String[] getIncidentIds() {
        return this.incidentIds;
    }

    public void setIncidentIds(String[] incidentIds) {
        this.incidentIds = incidentIds;
    }

    @Override
    public Incident[] getIncidents() {
        return this.incidents;
    }

    public void setIncidents(Incident[] incidents) {
        this.incidents = incidents;
    }

    protected void writeTree(StringWriter writer, String prefix, boolean isTail) {
        int i;
        writer.append(prefix);
        if (isTail) {
            writer.append("\u2514\u2500\u2500 ");
        } else {
            writer.append("\u251c\u2500\u2500 ");
        }
        writer.append(this.getActivityId() + "=>" + this.getId() + "\n");
        for (i = 0; i < this.childTransitionInstances.length; ++i) {
            TransitionInstance transitionInstance = this.childTransitionInstances[i];
            boolean transitionIsTail = i == this.childTransitionInstances.length - 1 && this.childActivityInstances.length == 0;
            this.writeTransition(transitionInstance, writer, prefix + (isTail ? "    " : "\u2502   "), transitionIsTail);
        }
        for (i = 0; i < this.childActivityInstances.length; ++i) {
            ActivityInstanceImpl child = (ActivityInstanceImpl)this.childActivityInstances[i];
            child.writeTree(writer, prefix + (isTail ? "    " : "\u2502   "), i == this.childActivityInstances.length - 1);
        }
    }

    protected void writeTransition(TransitionInstance transition, StringWriter writer, String prefix, boolean isTail) {
        writer.append(prefix);
        if (isTail) {
            writer.append("\u2514\u2500\u2500 ");
        } else {
            writer.append("\u251c\u2500\u2500 ");
        }
        writer.append("transition to/from " + transition.getActivityId() + ":" + transition.getId() + "\n");
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        this.writeTree(writer, "", true);
        return writer.toString();
    }

    @Override
    public ActivityInstance[] getActivityInstances(String activityId) {
        EnsureUtil.ensureNotNull("activityId", (Object)activityId);
        ArrayList<ActivityInstance> instances = new ArrayList<ActivityInstance>();
        this.collectActivityInstances(activityId, instances);
        return instances.toArray(new ActivityInstance[instances.size()]);
    }

    protected void collectActivityInstances(String activityId, List<ActivityInstance> instances) {
        if (this.activityId.equals(activityId)) {
            instances.add(this);
        } else {
            for (ActivityInstance childInstance : this.childActivityInstances) {
                ((ActivityInstanceImpl)childInstance).collectActivityInstances(activityId, instances);
            }
        }
    }

    @Override
    public TransitionInstance[] getTransitionInstances(String activityId) {
        EnsureUtil.ensureNotNull("activityId", (Object)activityId);
        ArrayList<TransitionInstance> instances = new ArrayList<TransitionInstance>();
        this.collectTransitionInstances(activityId, instances);
        return instances.toArray(new TransitionInstance[instances.size()]);
    }

    protected void collectTransitionInstances(String activityId, List<TransitionInstance> instances) {
        boolean instanceFound = false;
        for (TransitionInstance transitionInstance : this.childTransitionInstances) {
            if (!activityId.equals(transitionInstance.getActivityId())) continue;
            instances.add(transitionInstance);
            instanceFound = true;
        }
        if (!instanceFound) {
            for (ProcessElementInstance processElementInstance : this.childActivityInstances) {
                ((ActivityInstanceImpl)processElementInstance).collectTransitionInstances(activityId, instances);
            }
        }
    }

    public void setSubProcessInstanceId(String id) {
        this.subProcessInstanceId = id;
    }

    public String getSubProcessInstanceId() {
        return this.subProcessInstanceId;
    }
}

