/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.entity;

import io.openbpm.bpm.engine.impl.db.DbEntity;
import io.openbpm.bpm.engine.impl.db.HasDbRevision;
import io.openbpm.bpm.engine.impl.db.HistoricEntity;
import io.openbpm.bpm.engine.impl.util.StringUtil;
import io.openbpm.bpm.engine.task.Comment;
import io.openbpm.bpm.engine.task.Event;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class CommentEntity
implements Comment,
Event,
HasDbRevision,
DbEntity,
HistoricEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_EVENT = "event";
    public static final String TYPE_COMMENT = "comment";
    protected String id;
    protected String type;
    protected String userId;
    protected Date time;
    protected String taskId;
    protected String processInstanceId;
    protected String action;
    protected String message;
    protected String fullMessage;
    protected String tenantId;
    protected String rootProcessInstanceId;
    protected Date removalTime;
    protected int revision;
    public static final String MESSAGE_PARTS_MARKER = "_|_";

    @Override
    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("message", this.message);
        return persistentState;
    }

    public byte[] getFullMessageBytes() {
        return this.fullMessage != null ? StringUtil.toByteArray(this.fullMessage) : null;
    }

    public void setFullMessageBytes(byte[] fullMessageBytes) {
        this.fullMessage = fullMessageBytes != null ? StringUtil.fromBytes(fullMessageBytes) : null;
    }

    public void setMessage(String[] messageParts) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String part : messageParts) {
            if (part != null) {
                stringBuilder.append(part.replace(MESSAGE_PARTS_MARKER, " | "));
                stringBuilder.append(MESSAGE_PARTS_MARKER);
                continue;
            }
            stringBuilder.append("null");
            stringBuilder.append(MESSAGE_PARTS_MARKER);
        }
        for (int i = 0; i < MESSAGE_PARTS_MARKER.length(); ++i) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        this.message = stringBuilder.toString();
    }

    @Override
    public List<String> getMessageParts() {
        if (this.message == null) {
            return null;
        }
        ArrayList<String> messageParts = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.message, MESSAGE_PARTS_MARKER);
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if ("null".equals(nextToken)) {
                messageParts.add(null);
                continue;
            }
            messageParts.add(nextToken);
        }
        return messageParts;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getFullMessage() {
        return this.fullMessage;
    }

    public void setFullMessage(String fullMessage) {
        this.fullMessage = fullMessage;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    @Override
    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    public String toEventMessage(String message) {
        Object eventMessage = message.replaceAll("\\s+", " ");
        if (((String)eventMessage).length() > 163) {
            eventMessage = ((String)eventMessage).substring(0, 160) + "...";
        }
        return eventMessage;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", type=" + this.type + ", userId=" + this.userId + ", time=" + this.time + ", taskId=" + this.taskId + ", processInstanceId=" + this.processInstanceId + ", rootProcessInstanceId=" + this.rootProcessInstanceId + ", revision= " + this.revision + ", removalTime=" + this.removalTime + ", action=" + this.action + ", message=" + this.message + ", fullMessage=" + this.fullMessage + ", tenantId=" + this.tenantId + "]";
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }
}

