/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.entity;

import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.impl.DeploymentQueryImpl;
import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import io.openbpm.bpm.engine.impl.cmd.DeleteProcessDefinitionsByIdsCmd;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionManager;
import io.openbpm.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionManager;
import io.openbpm.bpm.engine.impl.form.entity.OperatonFormDefinitionManager;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.AbstractManager;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import io.openbpm.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.DeploymentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.OperatonFormDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ResourceEntity;
import io.openbpm.bpm.engine.impl.util.ClockUtil;
import io.openbpm.bpm.engine.repository.CaseDefinition;
import io.openbpm.bpm.engine.repository.DecisionDefinition;
import io.openbpm.bpm.engine.repository.DecisionRequirementsDefinition;
import io.openbpm.bpm.engine.repository.Deployment;
import io.openbpm.bpm.engine.repository.ProcessDefinition;
import io.openbpm.bpm.engine.repository.ResourceTypes;
import java.util.Arrays;
import java.util.List;

public class DeploymentManager
extends AbstractManager {
    public void insertDeployment(DeploymentEntity deployment) {
        this.getDbEntityManager().insert(deployment);
        this.createDefaultAuthorizations(deployment);
        for (ResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            resource.setType(ResourceTypes.REPOSITORY.getValue());
            resource.setCreateTime(ClockUtil.getCurrentTime());
            this.getResourceManager().insertResource(resource);
        }
        Context.getProcessEngineConfiguration().getDeploymentCache().deploy(deployment);
    }

    public void deleteDeployment(String deploymentId, boolean cascade) {
        this.deleteDeployment(deploymentId, cascade, false, false);
    }

    public void deleteDeployment(String deploymentId, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        String processDefinitionId;
        List<ProcessDefinition> processDefinitions = this.getProcessDefinitionManager().findProcessDefinitionsByDeploymentId(deploymentId);
        if (cascade) {
            for (ProcessDefinition processDefinition : processDefinitions) {
                processDefinitionId = processDefinition.getId();
                this.getProcessInstanceManager().deleteProcessInstancesByProcessDefinition(processDefinitionId, "deleted deployment", true, skipCustomListeners, skipIoMappings);
            }
            this.getHistoricJobLogManager().deleteHistoricJobLogsByDeploymentId(deploymentId);
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionId = processDefinition.getId();
            CommandContext commandContext = Context.getCommandContext();
            commandContext.runWithoutAuthorization(new DeleteProcessDefinitionsByIdsCmd(Arrays.asList(processDefinitionId), cascade, false, skipCustomListeners, false));
        }
        this.deleteCaseDeployment(deploymentId, cascade);
        this.deleteDecisionDeployment(deploymentId, cascade);
        this.deleteDecisionRequirementDeployment(deploymentId);
        this.deleteOperatonFormDefinitionDeployment(deploymentId);
        this.getResourceManager().deleteResourcesByDeploymentId(deploymentId);
        this.deleteAuthorizations(Resources.DEPLOYMENT, deploymentId);
        this.getDbEntityManager().delete(DeploymentEntity.class, "deleteDeployment", deploymentId);
    }

    protected void deleteCaseDeployment(String deploymentId, boolean cascade) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isCmmnEnabled()) {
            List<CaseDefinition> caseDefinitions = this.getCaseDefinitionManager().findCaseDefinitionByDeploymentId(deploymentId);
            if (cascade) {
                for (CaseDefinition caseDefinition : caseDefinitions) {
                    String caseDefinitionId = caseDefinition.getId();
                    this.getCaseInstanceManager().deleteCaseInstancesByCaseDefinition(caseDefinitionId, "deleted deployment", true);
                }
            }
            this.getCaseDefinitionManager().deleteCaseDefinitionsByDeploymentId(deploymentId);
            for (CaseDefinition caseDefinition : caseDefinitions) {
                String processDefinitionId = caseDefinition.getId();
                Context.getProcessEngineConfiguration().getDeploymentCache().removeCaseDefinition(processDefinitionId);
            }
        }
    }

    protected void deleteDecisionDeployment(String deploymentId, boolean cascade) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isDmnEnabled()) {
            DecisionDefinitionManager decisionDefinitionManager = this.getDecisionDefinitionManager();
            List<DecisionDefinition> decisionDefinitions = decisionDefinitionManager.findDecisionDefinitionByDeploymentId(deploymentId);
            if (cascade) {
                for (DecisionDefinition decisionDefinition : decisionDefinitions) {
                    this.getHistoricDecisionInstanceManager().deleteHistoricDecisionInstancesByDecisionDefinitionId(decisionDefinition.getId());
                }
            }
            decisionDefinitionManager.deleteDecisionDefinitionsByDeploymentId(deploymentId);
            DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
            for (DecisionDefinition decisionDefinition : decisionDefinitions) {
                String decisionDefinitionId = decisionDefinition.getId();
                deploymentCache.removeDecisionDefinition(decisionDefinitionId);
            }
        }
    }

    protected void deleteDecisionRequirementDeployment(String deploymentId) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isDmnEnabled()) {
            DecisionRequirementsDefinitionManager manager = this.getDecisionRequirementsDefinitionManager();
            List<DecisionRequirementsDefinition> decisionRequirementsDefinitions = manager.findDecisionRequirementsDefinitionByDeploymentId(deploymentId);
            manager.deleteDecisionRequirementsDefinitionsByDeploymentId(deploymentId);
            DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
            for (DecisionRequirementsDefinition decisionRequirementsDefinition : decisionRequirementsDefinitions) {
                String decisionDefinitionId = decisionRequirementsDefinition.getId();
                deploymentCache.removeDecisionRequirementsDefinition(decisionDefinitionId);
            }
        }
    }

    protected void deleteOperatonFormDefinitionDeployment(String deploymentId) {
        OperatonFormDefinitionManager manager = this.getOperatonFormDefinitionManager();
        List<OperatonFormDefinitionEntity> operatonFormDefinitions = manager.findDefinitionsByDeploymentId(deploymentId);
        manager.deleteOperatonFormDefinitionsByDeploymentId(deploymentId);
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
        for (OperatonFormDefinitionEntity operatonFormDefinition : operatonFormDefinitions) {
            deploymentCache.removeOperatonFormDefinition(operatonFormDefinition.getId());
        }
    }

    public DeploymentEntity findLatestDeploymentByName(String deploymentName) {
        List list = this.getDbEntityManager().selectList("selectDeploymentsByName", deploymentName, 0, 1);
        if (list != null && !list.isEmpty()) {
            return (DeploymentEntity)list.get(0);
        }
        return null;
    }

    public DeploymentEntity findDeploymentById(String deploymentId) {
        return this.getDbEntityManager().selectById(DeploymentEntity.class, deploymentId);
    }

    public List<DeploymentEntity> findDeploymentsByIds(String ... deploymentsIds) {
        return this.getDbEntityManager().selectList("selectDeploymentsByIds", deploymentsIds);
    }

    public long findDeploymentCountByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        this.configureQuery(deploymentQuery);
        return (Long)this.getDbEntityManager().selectOne("selectDeploymentCountByQueryCriteria", deploymentQuery);
    }

    public List<Deployment> findDeploymentsByQueryCriteria(DeploymentQueryImpl deploymentQuery, Page page) {
        this.configureQuery(deploymentQuery);
        return this.getDbEntityManager().selectList("selectDeploymentsByQueryCriteria", deploymentQuery, page);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.getDbEntityManager().selectList("selectResourceNamesByDeploymentId", deploymentId);
    }

    public List<String> findDeploymentIdsByProcessInstances(List<String> processInstanceIds) {
        return this.getDbEntityManager().selectList("selectDeploymentIdsByProcessInstances", processInstanceIds);
    }

    protected void createDefaultAuthorizations(DeploymentEntity deployment) {
        if (this.isAuthorizationEnabled()) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = provider.newDeployment(deployment);
            this.saveDefaultAuthorizations(authorizations);
        }
    }

    protected void configureQuery(DeploymentQueryImpl query) {
        this.getAuthorizationManager().configureDeploymentQuery(query);
        this.getTenantManager().configureQuery(query);
    }
}

