/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.entity;

import io.openbpm.bpm.engine.history.HistoricDetail;
import io.openbpm.bpm.engine.impl.HistoricDetailQueryImpl;
import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.db.ListQueryParameterObject;
import io.openbpm.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import io.openbpm.bpm.engine.impl.history.event.HistoricDetailEventEntity;
import io.openbpm.bpm.engine.impl.persistence.AbstractHistoricManager;
import io.openbpm.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricDetailManager
extends AbstractHistoricManager {
    private static final String VARIABLE_INSTANCE_ID = "variableInstanceId";

    public void deleteHistoricDetailsByProcessInstanceIds(List<String> historicProcessInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceIds", historicProcessInstanceIds);
        this.deleteHistoricDetails(parameters);
    }

    public void deleteHistoricDetailsByTaskProcessInstanceIds(List<String> historicProcessInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("taskProcessInstanceIds", historicProcessInstanceIds);
        this.deleteHistoricDetails(parameters);
    }

    public void deleteHistoricDetailsByCaseInstanceIds(List<String> historicCaseInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseInstanceIds", historicCaseInstanceIds);
        this.deleteHistoricDetails(parameters);
    }

    public void deleteHistoricDetailsByTaskCaseInstanceIds(List<String> historicCaseInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("taskCaseInstanceIds", historicCaseInstanceIds);
        this.deleteHistoricDetails(parameters);
    }

    public void deleteHistoricDetailsByVariableInstanceId(String historicVariableInstanceId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(VARIABLE_INSTANCE_ID, historicVariableInstanceId);
        this.deleteHistoricDetails(parameters);
    }

    public void deleteHistoricDetails(Map<String, Object> parameters) {
        this.getDbEntityManager().deletePreserveOrder(ByteArrayEntity.class, "deleteHistoricDetailByteArraysByIds", parameters);
        this.getDbEntityManager().deletePreserveOrder(HistoricDetailEventEntity.class, "deleteHistoricDetailsByIds", parameters);
    }

    public long findHistoricDetailCountByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery) {
        this.configureQuery(historicVariableUpdateQuery);
        return (Long)this.getDbEntityManager().selectOne("selectHistoricDetailCountByQueryCriteria", historicVariableUpdateQuery);
    }

    public List<HistoricDetail> findHistoricDetailsByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery, Page page) {
        this.configureQuery(historicVariableUpdateQuery);
        return this.getDbEntityManager().selectList("selectHistoricDetailsByQueryCriteria", historicVariableUpdateQuery, page);
    }

    public void deleteHistoricDetailsByTaskId(String taskId) {
        if (this.isHistoryEnabled()) {
            List<HistoricDetail> historicDetails = this.findHistoricDetailsByTaskId(taskId);
            for (HistoricDetail historicDetail : historicDetails) {
                ((HistoricDetailEventEntity)((Object)historicDetail)).delete();
            }
            List<HistoricDetailEventEntity> cachedHistoricDetails = this.getDbEntityManager().getCachedEntitiesByType(HistoricDetailEventEntity.class);
            for (HistoricDetailEventEntity historicDetail : cachedHistoricDetails) {
                if (!taskId.equals(historicDetail.getTaskId())) continue;
                historicDetail.delete();
            }
        }
    }

    public List<HistoricDetail> findHistoricDetailsByTaskId(String taskId) {
        return this.getDbEntityManager().selectList("selectHistoricDetailsByTaskId", taskId);
    }

    protected void configureQuery(HistoricDetailQueryImpl query) {
        this.getAuthorizationManager().configureHistoricDetailQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    public DbOperation addRemovalTimeToDetailsByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(HistoricDetailEventEntity.class, "updateHistoricDetailsByRootProcessInstanceId", parameters);
    }

    public DbOperation addRemovalTimeToDetailsByProcessInstanceId(String processInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(HistoricDetailEventEntity.class, "updateHistoricDetailsByProcessInstanceId", parameters);
    }

    public DbOperation deleteHistoricDetailsByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(HistoricDetailEventEntity.class, "deleteHistoricDetailsByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }
}

