/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.entity;

import io.openbpm.bpm.engine.impl.DefaultPriorityProvider;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.DbEntity;
import io.openbpm.bpm.engine.impl.db.DbEntityLifecycleAware;
import io.openbpm.bpm.engine.impl.db.EnginePersistenceLogger;
import io.openbpm.bpm.engine.impl.db.HasDbReferences;
import io.openbpm.bpm.engine.impl.db.HasDbRevision;
import io.openbpm.bpm.engine.impl.incident.IncidentContext;
import io.openbpm.bpm.engine.impl.incident.IncidentHandling;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobHandler;
import io.openbpm.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import io.openbpm.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import io.openbpm.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.SuspensionState;
import io.openbpm.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.impl.util.ExceptionUtil;
import io.openbpm.bpm.engine.impl.util.StringUtil;
import io.openbpm.bpm.engine.management.JobDefinition;
import io.openbpm.bpm.engine.repository.ResourceTypes;
import io.openbpm.bpm.engine.runtime.Incident;
import io.openbpm.bpm.engine.runtime.Job;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class JobEntity
extends AcquirableJobEntity
implements Serializable,
Job,
DbEntity,
HasDbRevision,
HasDbReferences,
DbEntityLifecycleAware {
    private static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    public static final int DEFAULT_RETRIES = 3;
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected int retries = 3;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String jobHandlerType;
    protected String jobHandlerConfiguration;
    protected ByteArrayEntity exceptionByteArray;
    protected String exceptionByteArrayId;
    protected String exceptionMessage;
    protected String deploymentId;
    protected String jobDefinitionId;
    protected long priority = DefaultPriorityProvider.DEFAULT_PRIORITY;
    protected String tenantId;
    protected Date createTime;
    protected String activityId;
    protected JobDefinition jobDefinition;
    protected ExecutionEntity execution;
    protected long sequenceCounter = 1L;
    protected String lastFailureLogId;
    protected String failedActivityId;
    protected Map<String, Class> persistedDependentEntities;
    protected String batchId;

    public void execute(CommandContext commandContext) {
        if (this.executionId != null) {
            EnsureUtil.ensureNotNull("Cannot find execution with id '" + this.executionId + "' referenced from job '" + this + "'", "execution", (Object)this.getExecution());
        }
        this.getActivityId();
        this.incrementSequenceCounter();
        this.preExecute(commandContext);
        JobHandler jobHandler = this.getJobHandler();
        JobHandlerConfiguration configuration = this.getJobHandlerConfiguration();
        EnsureUtil.ensureNotNull("Cannot find job handler '" + this.jobHandlerType + "' from job '" + this + "'", "jobHandler", (Object)jobHandler);
        jobHandler.execute(configuration, this.execution, commandContext, this.tenantId);
        this.postExecute(commandContext);
    }

    protected void preExecute(CommandContext commandContext) {
    }

    protected void postExecute(CommandContext commandContext) {
        LOG.debugJobExecuted(this);
        this.delete(true);
        commandContext.getHistoricJobLogManager().fireJobSuccessfulEvent(this);
    }

    public void init(CommandContext commandContext) {
    }

    public void init(CommandContext commandContext, boolean shouldResetLock, boolean shouldCallDeleteHandler) {
        JobHandler jobHandler;
        if (shouldCallDeleteHandler && (jobHandler = this.getJobHandler()) != null) {
            jobHandler.onDelete(this.getJobHandlerConfiguration(), this);
        }
        int maxRetries = HistoryCleanupHelper.getMaxRetries();
        this.setRetries(maxRetries);
        if (this.exceptionByteArrayId != null) {
            this.clearFailedJobException();
        }
        if (shouldResetLock) {
            this.setLockOwner(null);
            this.setLockExpirationTime(null);
        }
    }

    public void insert() {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntity exec = this.getExecution();
        if (exec != null) {
            exec.addJob(this);
            ProcessDefinitionEntity processDefinition = exec.getProcessDefinition();
            this.deploymentId = ((ProcessDefinitionImpl)processDefinition).getDeploymentId();
        }
        commandContext.getJobManager().insertJob(this);
    }

    public void delete() {
        this.delete(false);
    }

    public void delete(boolean incidentResolved) {
        ExecutionEntity exec;
        CommandContext commandContext = Context.getCommandContext();
        this.incrementSequenceCounter();
        JobHandler jobHandler = this.getJobHandler();
        if (jobHandler != null) {
            jobHandler.onDelete(this.getJobHandlerConfiguration(), this);
        }
        boolean executingJob = this.equals(commandContext.getCurrentJob());
        commandContext.getJobManager().deleteJob(this, !executingJob);
        if (this.exceptionByteArrayId != null) {
            commandContext.getByteArrayManager().deleteByteArrayById(this.exceptionByteArrayId);
        }
        if ((exec = this.getExecution()) != null) {
            exec.removeJob(this);
        }
        this.removeFailedJobIncident(incidentResolved);
    }

    @Override
    public Object getPersistentState() {
        HashMap persistentState = (HashMap)super.getPersistentState();
        persistentState.put("executionId", this.executionId);
        persistentState.put("retries", this.retries);
        persistentState.put("exceptionMessage", this.exceptionMessage);
        persistentState.put("suspensionState", this.suspensionState);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("jobDefinitionId", this.jobDefinitionId);
        persistentState.put("deploymentId", this.deploymentId);
        persistentState.put("jobHandlerConfiguration", this.jobHandlerConfiguration);
        persistentState.put("priority", this.priority);
        persistentState.put("tenantId", this.tenantId);
        if (this.exceptionByteArrayId != null) {
            persistentState.put("exceptionByteArrayId", this.exceptionByteArrayId);
        }
        return persistentState;
    }

    public void setExecution(ExecutionEntity execution) {
        if (execution != null) {
            this.execution = execution;
            this.executionId = execution.getId();
            this.processInstanceId = execution.getProcessInstanceId();
            this.rootProcessInstanceId = execution.getRootProcessInstanceId();
            if (execution.isSuspended()) {
                this.suspensionState = execution.getSuspensionState();
            }
            this.execution.addJob(this);
        } else {
            this.execution.removeJob(this);
            this.execution = execution;
            this.processInstanceId = null;
            this.rootProcessInstanceId = null;
            this.executionId = null;
        }
    }

    public long getSequenceCounter() {
        return this.sequenceCounter;
    }

    public void setSequenceCounter(long sequenceCounter) {
        this.sequenceCounter = sequenceCounter;
    }

    public void incrementSequenceCounter() {
        ++this.sequenceCounter;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public ExecutionEntity getExecution() {
        this.ensureExecutionInitialized();
        return this.execution;
    }

    protected void ensureExecutionInitialized() {
        if (this.execution == null && this.executionId != null) {
            this.execution = Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
        }
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        if (retries < 0) {
            retries = 0;
        }
        if (this.retries == 0 && retries > 0) {
            this.removeFailedJobIncident(true);
        }
        if (retries == 0 && this.retries > 0) {
            this.createFailedJobIncident();
        }
        this.retries = retries;
    }

    public void setRetriesFromPersistence(int retries) {
        this.retries = retries;
    }

    protected void createFailedJobIncident() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isCreateIncidentOnFailedJobEnabled()) {
            String incidentHandlerType = "failedJob";
            if (this.id == null) {
                this.id = processEngineConfiguration.getIdGenerator().getNextId();
            } else {
                List<Incident> failedJobIncidents = Context.getCommandContext().getIncidentManager().findIncidentByConfigurationAndIncidentType(this.id, incidentHandlerType);
                if (!failedJobIncidents.isEmpty()) {
                    for (Incident incident : failedJobIncidents) {
                        HistoricIncidentEntity historicIncidentEvent = Context.getCommandContext().getHistoricIncidentManager().findHistoricIncidentById(incident.getId());
                        if (historicIncidentEvent == null) continue;
                        historicIncidentEvent.setHistoryConfiguration(this.getLastFailureLogId());
                        Context.getCommandContext().getDbEntityManager().merge(historicIncidentEvent);
                    }
                    return;
                }
            }
            IncidentContext incidentContext = this.createIncidentContext();
            incidentContext.setActivityId(this.getActivityId());
            incidentContext.setHistoryConfiguration(this.getLastFailureLogId());
            incidentContext.setFailedActivityId(this.getFailedActivityId());
            IncidentHandling.createIncident(incidentHandlerType, incidentContext, this.exceptionMessage);
        }
    }

    protected void removeFailedJobIncident(boolean incidentResolved) {
        IncidentContext incidentContext = this.createIncidentContext();
        IncidentHandling.removeIncidents("failedJob", incidentContext, incidentResolved);
    }

    protected IncidentContext createIncidentContext() {
        IncidentContext incidentContext = new IncidentContext();
        incidentContext.setProcessDefinitionId(this.processDefinitionId);
        incidentContext.setExecutionId(this.executionId);
        incidentContext.setTenantId(this.tenantId);
        incidentContext.setConfiguration(this.id);
        incidentContext.setJobDefinitionId(this.jobDefinitionId);
        return incidentContext;
    }

    public String getExceptionStacktrace() {
        ByteArrayEntity byteArray = this.getExceptionByteArray();
        return ExceptionUtil.getExceptionStacktrace(byteArray);
    }

    public void setSuspensionState(int state) {
        this.suspensionState = state;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public void setExceptionStacktrace(String exception) {
        byte[] exceptionBytes = StringUtil.toByteArray(exception);
        ByteArrayEntity byteArray = this.getExceptionByteArray();
        if (byteArray == null) {
            byteArray = ExceptionUtil.createJobExceptionByteArray(exceptionBytes, ResourceTypes.RUNTIME);
            this.exceptionByteArrayId = byteArray.getId();
            this.exceptionByteArray = byteArray;
        } else {
            byteArray.setBytes(exceptionBytes);
        }
    }

    protected JobHandler getJobHandler() {
        Map<String, JobHandler> jobHandlers = Context.getProcessEngineConfiguration().getJobHandlers();
        return jobHandlers.get(this.jobHandlerType);
    }

    public JobHandlerConfiguration getJobHandlerConfiguration() {
        return this.getJobHandler().newConfiguration(this.jobHandlerConfiguration);
    }

    public void setJobHandlerConfiguration(JobHandlerConfiguration configuration) {
        this.jobHandlerConfiguration = configuration.toCanonicalString();
    }

    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public String getJobHandlerConfigurationRaw() {
        return this.jobHandlerConfiguration;
    }

    public void setJobHandlerConfigurationRaw(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    @Override
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public JobDefinition getJobDefinition() {
        this.ensureJobDefinitionInitialized();
        return this.jobDefinition;
    }

    public void setJobDefinition(JobDefinition jobDefinition) {
        this.jobDefinition = jobDefinition;
        this.jobDefinitionId = jobDefinition != null ? jobDefinition.getId() : null;
    }

    protected void ensureJobDefinitionInitialized() {
        if (this.jobDefinition == null && this.jobDefinitionId != null) {
            this.jobDefinition = Context.getCommandContext().getJobDefinitionManager().findById(this.jobDefinitionId);
        }
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = StringUtil.trimToMaximumLengthAllowed(exceptionMessage);
    }

    public String getExceptionByteArrayId() {
        return this.exceptionByteArrayId;
    }

    protected ByteArrayEntity getExceptionByteArray() {
        this.ensureExceptionByteArrayInitialized();
        return this.exceptionByteArray;
    }

    protected void ensureExceptionByteArrayInitialized() {
        if (this.exceptionByteArray == null && this.exceptionByteArrayId != null) {
            this.exceptionByteArray = Context.getCommandContext().getDbEntityManager().selectById(ByteArrayEntity.class, this.exceptionByteArrayId);
        }
    }

    protected void clearFailedJobException() {
        ByteArrayEntity byteArray = this.getExceptionByteArray();
        if (byteArray != null) {
            Context.getCommandContext().getDbEntityManager().delete(byteArray);
        }
        this.exceptionByteArrayId = null;
        this.exceptionMessage = null;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public boolean isInInconsistentLockState() {
        return this.lockOwner != null && this.lockExpirationTime == null || this.retries == 0 && (this.lockOwner != null || this.lockExpirationTime != null);
    }

    public void resetLock() {
        this.lockOwner = null;
        this.lockExpirationTime = null;
    }

    public String getActivityId() {
        this.ensureActivityIdInitialized();
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public long getPriority() {
        return this.priority;
    }

    public void setPriority(long priority) {
        this.priority = priority;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    protected void ensureActivityIdInitialized() {
        if (this.activityId == null) {
            JobDefinition jobDef = this.getJobDefinition();
            if (jobDef != null) {
                this.activityId = jobDef.getActivityId();
            } else {
                ExecutionEntity exec = this.getExecution();
                if (exec != null) {
                    this.activityId = exec.getActivityId();
                }
            }
        }
    }

    public void unlock() {
        this.lockOwner = null;
        this.lockExpirationTime = null;
    }

    public abstract String getType();

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobEntity other = (JobEntity)obj;
        if (this.id == null) {
            return other.id == null;
        }
        return this.id.equals(other.id);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        return new HashSet<String>();
    }

    @Override
    public Map<String, Class> getReferencedEntitiesIdAndClass() {
        HashMap<String, Class> referenceIdAndClass = new HashMap<String, Class>();
        if (this.exceptionByteArrayId != null) {
            referenceIdAndClass.put(this.exceptionByteArrayId, ByteArrayEntity.class);
        }
        return referenceIdAndClass;
    }

    @Override
    public Map<String, Class> getDependentEntities() {
        return this.persistedDependentEntities;
    }

    @Override
    public void postLoad() {
        if (this.exceptionByteArrayId != null) {
            this.persistedDependentEntities = new HashMap<String, Class>();
            this.persistedDependentEntities.put(this.exceptionByteArrayId, ByteArrayEntity.class);
        } else {
            this.persistedDependentEntities = Collections.emptyMap();
        }
    }

    public String getLastFailureLogId() {
        return this.lastFailureLogId;
    }

    public void setLastFailureLogId(String lastFailureLogId) {
        this.lastFailureLogId = lastFailureLogId;
    }

    @Override
    public String getFailedActivityId() {
        return this.failedActivityId;
    }

    public void setFailedActivityId(String failedActivityId) {
        this.failedActivityId = failedActivityId;
    }

    @Override
    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", revision=" + this.revision + ", duedate=" + this.duedate + ", lockOwner=" + this.lockOwner + ", lockExpirationTime=" + this.lockExpirationTime + ", executionId=" + this.executionId + ", processInstanceId=" + this.processInstanceId + ", isExclusive=" + this.isExclusive + ", jobDefinitionId=" + this.jobDefinitionId + ", jobHandlerType=" + this.jobHandlerType + ", jobHandlerConfiguration=" + this.jobHandlerConfiguration + ", exceptionByteArray=" + this.exceptionByteArray + ", exceptionByteArrayId=" + this.exceptionByteArrayId + ", exceptionMessage=" + this.exceptionMessage + ", failedActivityId=" + this.failedActivityId + ", deploymentId=" + this.deploymentId + ", priority=" + this.priority + ", tenantId=" + this.tenantId + ", batchId=" + this.batchId + "]";
    }
}

