/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.entity;

import io.openbpm.bpm.engine.impl.Direction;
import io.openbpm.bpm.engine.impl.JobQueryImpl;
import io.openbpm.bpm.engine.impl.JobQueryProperty;
import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.QueryOrderingProperty;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cfg.TransactionListener;
import io.openbpm.bpm.engine.impl.cfg.TransactionState;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.ListQueryParameterObject;
import io.openbpm.bpm.engine.impl.jobexecutor.ExclusiveJobAddedNotification;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutor;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutorContext;
import io.openbpm.bpm.engine.impl.jobexecutor.MessageAddedNotification;
import io.openbpm.bpm.engine.impl.persistence.AbstractManager;
import io.openbpm.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.EverLivingJobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.MessageEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.SuspensionState;
import io.openbpm.bpm.engine.impl.persistence.entity.TimerEntity;
import io.openbpm.bpm.engine.impl.util.ClockUtil;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.impl.util.ImmutablePair;
import io.openbpm.bpm.engine.runtime.Job;
import io.openbpm.commons.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class JobManager
extends AbstractManager {
    public static final QueryOrderingProperty JOB_PRIORITY_ORDERING_PROPERTY = new QueryOrderingProperty(null, JobQueryProperty.PRIORITY);
    public static final QueryOrderingProperty JOB_TYPE_ORDERING_PROPERTY = new QueryOrderingProperty(null, JobQueryProperty.TYPE);
    public static final QueryOrderingProperty JOB_DUEDATE_ORDERING_PROPERTY = new QueryOrderingProperty(null, JobQueryProperty.DUEDATE);
    private static final String JOB_ID = "jobId";
    private static final String HANDLER_TYPE = "handlerType";
    private static final String RETRIES = "retries";
    private static final String DUE_DATE = "dueDate";
    private static final String IS_DUE_DATE_SET = "isDueDateSet";
    private static final String PRIORITY = "priority";
    private static final String DEPLOYMENT_IDS = "deploymentIds";
    private static final String NOW = "now";
    private static final String ALWAYS_SET_DUE_DATE = "alwaysSetDueDate";
    private static final String DEPLOYMENT_AWARE = "deploymentAware";
    private static final String JOB_PRIORITY_MIN = "jobPriorityMin";
    private static final String JOB_PRIORITY_MAX = "jobPriorityMax";
    private static final String HISTORY_CLEANUP_ENABLED = "historyCleanupEnabled";

    public void updateJob(JobEntity job) {
        this.getDbEntityManager().merge(job);
    }

    public void insertJob(JobEntity job) {
        job.setCreateTime(ClockUtil.getCurrentTime());
        this.getDbEntityManager().insert(job);
        this.getHistoricJobLogManager().fireJobCreatedEvent(job);
    }

    public void deleteJob(JobEntity job) {
        this.deleteJob(job, true);
    }

    public void deleteJob(JobEntity job, boolean fireDeleteEvent) {
        this.getDbEntityManager().delete(job);
        if (fireDeleteEvent) {
            this.getHistoricJobLogManager().fireJobDeletedEvent(job);
        }
    }

    public void insertAndHintJobExecutor(JobEntity jobEntity) {
        jobEntity.insert();
        if (Context.getProcessEngineConfiguration().isHintJobExecutor()) {
            this.hintJobExecutor(jobEntity);
        }
    }

    public void send(MessageEntity message) {
        message.insert();
        if (Context.getProcessEngineConfiguration().isHintJobExecutor()) {
            this.hintJobExecutor(message);
        }
    }

    public void schedule(TimerEntity timer) {
        Date duedate = timer.getDuedate();
        EnsureUtil.ensureNotNull("duedate", (Object)duedate);
        timer.insert();
        this.hintJobExecutorIfNeeded(timer, duedate);
    }

    public void reschedule(JobEntity jobEntity, Date newDuedate) {
        if (jobEntity instanceof EverLivingJobEntity || jobEntity instanceof MessageEntity) {
            jobEntity.init(Context.getCommandContext(), true, false);
            jobEntity.setSuspensionState(SuspensionState.ACTIVE.getStateCode());
            jobEntity.setDuedate(newDuedate);
            this.hintJobExecutorIfNeeded(jobEntity, newDuedate);
        }
    }

    private void hintJobExecutorIfNeeded(JobEntity jobEntity, Date duedate) {
        JobExecutor jobExecutor = Context.getProcessEngineConfiguration().getJobExecutor();
        int waitTimeInMillis = jobExecutor.getWaitTimeInMillis();
        if (duedate.getTime() < ClockUtil.getCurrentTime().getTime() + (long)waitTimeInMillis) {
            this.hintJobExecutor(jobEntity);
        }
    }

    protected void hintJobExecutor(JobEntity job) {
        JobExecutor jobExecutor = Context.getProcessEngineConfiguration().getJobExecutor();
        if (!jobExecutor.isActive()) {
            return;
        }
        JobExecutorContext jobExecutorContext = Context.getJobExecutorContext();
        TransactionListener transactionListener = null;
        if (this.isJobPriorityInJobExecutorPriorityRange(job.getPriority())) {
            if (!job.isSuspended() && job.isExclusive() && this.isJobDue(job) && jobExecutorContext != null && jobExecutorContext.isExecutingExclusiveJob() && this.areInSameProcessInstance(job, jobExecutorContext.getCurrentJob())) {
                Date currentTime = ClockUtil.getCurrentTime();
                job.setLockExpirationTime(new Date(currentTime.getTime() + (long)jobExecutor.getLockTimeInMillis()));
                job.setLockOwner(jobExecutor.getLockOwner());
                transactionListener = new ExclusiveJobAddedNotification(job.getId(), jobExecutorContext);
            } else {
                transactionListener = new MessageAddedNotification(jobExecutor);
            }
            Context.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.COMMITTED, transactionListener);
        }
    }

    protected boolean areInSameProcessInstance(JobEntity job1, JobEntity job2) {
        if (job1 == null || job2 == null) {
            return false;
        }
        return Objects.equals(job1.getProcessInstanceId(), job2.getProcessInstanceId());
    }

    protected boolean isJobPriorityInJobExecutorPriorityRange(long jobPriority) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        return configuration.getJobExecutorPriorityRangeMin() <= jobPriority && configuration.getJobExecutorPriorityRangeMax() >= jobPriority;
    }

    public void cancelTimers(ExecutionEntity execution) {
        List<TimerEntity> timers = Context.getCommandContext().getJobManager().findTimersByExecutionId(execution.getId());
        for (TimerEntity timer : timers) {
            timer.delete();
        }
    }

    public JobEntity findJobById(String jobId) {
        return (JobEntity)this.getDbEntityManager().selectOne("selectJob", jobId);
    }

    public List<AcquirableJobEntity> findNextJobsToExecute(Page page) {
        Set<String> registeredDeployments;
        ProcessEngineConfigurationImpl engineConfiguration = Context.getProcessEngineConfiguration();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Date now = ClockUtil.getCurrentTime();
        params.put(NOW, now);
        params.put(ALWAYS_SET_DUE_DATE, this.isEnsureJobDueDateNotNull());
        params.put(DEPLOYMENT_AWARE, engineConfiguration.isJobExecutorDeploymentAware());
        if (engineConfiguration.isJobExecutorDeploymentAware() && !(registeredDeployments = engineConfiguration.getRegisteredDeployments()).isEmpty()) {
            params.put(DEPLOYMENT_IDS, registeredDeployments);
        }
        boolean jobExecutorAcquireByPriority = engineConfiguration.isJobExecutorAcquireByPriority();
        long jobExecutorPriorityRangeMin = engineConfiguration.getJobExecutorPriorityRangeMin();
        long jobExecutorPriorityRangeMax = engineConfiguration.getJobExecutorPriorityRangeMax();
        params.put(JOB_PRIORITY_MIN, jobExecutorAcquireByPriority && jobExecutorPriorityRangeMin != Long.MIN_VALUE ? Long.valueOf(jobExecutorPriorityRangeMin) : null);
        params.put(JOB_PRIORITY_MAX, jobExecutorAcquireByPriority && jobExecutorPriorityRangeMax != Long.MAX_VALUE ? Long.valueOf(jobExecutorPriorityRangeMax) : null);
        params.put(HISTORY_CLEANUP_ENABLED, engineConfiguration.isHistoryCleanupEnabled());
        ArrayList<QueryOrderingProperty> orderingProperties = new ArrayList<QueryOrderingProperty>();
        if (engineConfiguration.isJobExecutorAcquireByPriority()) {
            orderingProperties.add(JOB_PRIORITY_ORDERING_PROPERTY);
        }
        if (engineConfiguration.isJobExecutorPreferTimerJobs()) {
            orderingProperties.add(JOB_TYPE_ORDERING_PROPERTY);
        }
        if (engineConfiguration.isJobExecutorAcquireByDueDate()) {
            orderingProperties.add(JOB_DUEDATE_ORDERING_PROPERTY);
        }
        params.put("orderingProperties", orderingProperties);
        params.put("applyOrdering", !orderingProperties.isEmpty());
        params.put("applyExclusiveOverProcessHierarchies", engineConfiguration.isJobExecutorAcquireExclusiveOverProcessHierarchies());
        return this.getDbEntityManager().selectList("selectNextJobsToExecute", params, page);
    }

    public List<JobEntity> findJobsByExecutionId(String executionId) {
        return this.getDbEntityManager().selectList("selectJobsByExecutionId", executionId);
    }

    public List<JobEntity> findJobsByProcessInstanceId(String processInstanceId) {
        return this.getDbEntityManager().selectList("selectJobsByProcessInstanceId", processInstanceId);
    }

    public List<JobEntity> findJobsByJobDefinitionId(String jobDefinitionId) {
        return this.getDbEntityManager().selectList("selectJobsByJobDefinitionId", jobDefinitionId);
    }

    public List<Job> findJobsByHandlerType(String handlerType) {
        return this.getDbEntityManager().selectList("selectJobsByHandlerType", handlerType);
    }

    public List<TimerEntity> findUnlockedTimersByDuedate(Date duedate, Page page) {
        String query = "selectUnlockedTimersByDuedate";
        return this.getDbEntityManager().selectList("selectUnlockedTimersByDuedate", duedate, page);
    }

    public List<TimerEntity> findTimersByExecutionId(String executionId) {
        return this.getDbEntityManager().selectList("selectTimersByExecutionId", executionId);
    }

    public List<Job> findJobsByQueryCriteria(JobQueryImpl jobQuery, Page page) {
        this.configureQuery(jobQuery);
        return this.getDbEntityManager().selectList("selectJobByQueryCriteria", jobQuery, page);
    }

    public List<ImmutablePair<String, String>> findDeploymentIdMappingsByQueryCriteria(JobQueryImpl jobQuery) {
        this.configureQuery(jobQuery);
        Set<String> processInstanceIds = jobQuery.getProcessInstanceIds();
        if (processInstanceIds != null && !processInstanceIds.isEmpty()) {
            List partitions = CollectionUtil.partition(new ArrayList<String>(processInstanceIds), (int)2000);
            ArrayList<ImmutablePair<String, String>> result = new ArrayList<ImmutablePair<String, String>>();
            partitions.stream().forEach(partition -> {
                jobQuery.processInstanceIds(new HashSet<String>((Collection<String>)partition));
                result.addAll(this.getDbEntityManager().selectList("selectJobDeploymentIdMappingsByQueryCriteria", jobQuery));
            });
            return result;
        }
        return this.getDbEntityManager().selectList("selectJobDeploymentIdMappingsByQueryCriteria", jobQuery);
    }

    public List<JobEntity> findJobsByConfiguration(String jobHandlerType, String jobHandlerConfiguration, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(HANDLER_TYPE, jobHandlerType);
        params.put("handlerConfiguration", jobHandlerConfiguration);
        params.put("tenantId", tenantId);
        if ("timer-intermediate-transition".equals(jobHandlerType) || "timer-transition".equals(jobHandlerType) || "timer-start-event".equals(jobHandlerType) || "timer-start-event-subprocess".equals(jobHandlerType)) {
            String queryValue = jobHandlerConfiguration + "$followUpJobCreated";
            params.put("handlerConfigurationWithFollowUpJobCreatedProperty", queryValue);
        }
        return this.getDbEntityManager().selectList("selectJobsByConfiguration", params);
    }

    public long findJobCountByQueryCriteria(JobQueryImpl jobQuery) {
        this.configureQuery(jobQuery);
        return (Long)this.getDbEntityManager().selectOne("selectJobCountByQueryCriteria", jobQuery);
    }

    public void updateJobSuspensionStateById(String jobId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(JOB_ID, jobId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobSuspensionStateByJobDefinitionId(String jobDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobDefinitionId", jobDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobSuspensionStateByProcessInstanceId(String processInstanceId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateStartTimerJobSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        parameters.put(HANDLER_TYPE, "timer-start-event");
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", false);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobSuspensionStateByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String processDefinitionTenantId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", true);
        parameters.put("processDefinitionTenantId", processDefinitionTenantId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateStartTimerJobSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", false);
        parameters.put("suspensionState", suspensionState.getStateCode());
        parameters.put(HANDLER_TYPE, "timer-start-event");
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateStartTimerJobSuspensionStateByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String processDefinitionTenantId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", true);
        parameters.put("processDefinitionTenantId", processDefinitionTenantId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        parameters.put(HANDLER_TYPE, "timer-start-event");
        this.getDbEntityManager().update(JobEntity.class, "updateJobSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateFailedJobRetriesByJobDefinitionId(String jobDefinitionId, int retries, Date dueDate, boolean isDueDateSet) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobDefinitionId", jobDefinitionId);
        parameters.put(RETRIES, retries);
        parameters.put(DUE_DATE, dueDate);
        parameters.put(IS_DUE_DATE_SET, isDueDateSet);
        this.getDbEntityManager().update(JobEntity.class, "updateFailedJobRetriesByParameters", parameters);
    }

    public void updateJobPriorityByDefinitionId(String jobDefinitionId, long priority) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobDefinitionId", jobDefinitionId);
        parameters.put(PRIORITY, priority);
        this.getDbEntityManager().update(JobEntity.class, "updateJobPriorityByDefinitionId", parameters);
    }

    protected void configureQuery(JobQueryImpl query) {
        this.getAuthorizationManager().configureJobQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }

    protected boolean isEnsureJobDueDateNotNull() {
        return Context.getProcessEngineConfiguration().isEnsureJobDueDateNotNull();
    }

    protected boolean isJobDue(JobEntity job) {
        Date duedate = job.getDuedate();
        Date now = ClockUtil.getCurrentTime();
        return duedate == null || duedate.getTime() <= now.getTime();
    }

    static {
        JOB_PRIORITY_ORDERING_PROPERTY.setDirection(Direction.DESCENDING);
        JOB_TYPE_ORDERING_PROPERTY.setDirection(Direction.DESCENDING);
        JOB_DUEDATE_ORDERING_PROPERTY.setDirection(Direction.ASCENDING);
    }
}

