/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.entity;

import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.VariableInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.persistence.AbstractManager;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import io.openbpm.bpm.engine.runtime.VariableInstance;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariableInstanceManager
extends AbstractManager {
    private static final String CASE_EXECUTION_ID = "caseExecutionId";
    private static final String EXECUTION_ID = "executionId";
    private static final String VARIABLE_NAMES = "variableNames";

    public List<VariableInstanceEntity> findVariableInstancesByTaskId(String taskId) {
        return this.findVariableInstancesByTaskIdAndVariableNames(taskId, null);
    }

    public List<VariableInstanceEntity> findVariableInstancesByTaskIdAndVariableNames(String taskId, Collection<String> variableNames) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("taskId", taskId);
        parameter.put(VARIABLE_NAMES, variableNames);
        return this.getDbEntityManager().selectList("selectVariablesByTaskId", parameter);
    }

    public List<VariableInstanceEntity> findVariableInstancesByExecutionId(String executionId) {
        return this.findVariableInstancesByExecutionIdAndVariableNames(executionId, null);
    }

    public List<VariableInstanceEntity> findVariableInstancesByExecutionIdAndVariableNames(String executionId, Collection<String> variableNames) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put(EXECUTION_ID, executionId);
        parameter.put(VARIABLE_NAMES, variableNames);
        return this.getDbEntityManager().selectList("selectVariablesByExecutionId", parameter);
    }

    public List<VariableInstanceEntity> findVariableInstancesByProcessInstanceId(String processInstanceId) {
        return this.getDbEntityManager().selectList("selectVariablesByProcessInstanceId", processInstanceId);
    }

    public List<VariableInstanceEntity> findVariableInstancesByCaseExecutionId(String caseExecutionId) {
        return this.findVariableInstancesByCaseExecutionIdAndVariableNames(caseExecutionId, null);
    }

    public List<VariableInstanceEntity> findVariableInstancesByCaseExecutionIdAndVariableNames(String caseExecutionId, Collection<String> variableNames) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put(CASE_EXECUTION_ID, caseExecutionId);
        parameter.put(VARIABLE_NAMES, variableNames);
        return this.getDbEntityManager().selectList("selectVariablesByCaseExecutionId", parameter);
    }

    public void deleteVariableInstanceByTask(TaskEntity task) {
        List<VariableInstanceEntity> variableInstances = task.variableStore.getVariables();
        for (VariableInstanceEntity variableInstance : variableInstances) {
            variableInstance.delete();
        }
    }

    public long findVariableInstanceCountByQueryCriteria(VariableInstanceQueryImpl variableInstanceQuery) {
        this.configureQuery(variableInstanceQuery);
        return (Long)this.getDbEntityManager().selectOne("selectVariableInstanceCountByQueryCriteria", variableInstanceQuery);
    }

    public List<VariableInstance> findVariableInstanceByQueryCriteria(VariableInstanceQueryImpl variableInstanceQuery, Page page) {
        this.configureQuery(variableInstanceQuery);
        return this.getDbEntityManager().selectList("selectVariableInstanceByQueryCriteria", variableInstanceQuery, page);
    }

    protected void configureQuery(VariableInstanceQueryImpl query) {
        this.getAuthorizationManager().configureVariableInstanceQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    public List<VariableInstanceEntity> findVariableInstancesByBatchId(String batchId) {
        Map<String, String> parameters = Collections.singletonMap("batchId", batchId);
        return this.getDbEntityManager().selectList("selectVariableInstancesByBatchId", parameters);
    }
}

