/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.pvm.runtime;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.delegate.BaseDelegateExecution;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.bpmn.helper.BpmnProperties;
import io.openbpm.bpm.engine.impl.cmmn.execution.CmmnExecution;
import io.openbpm.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.core.delegate.CoreActivityBehavior;
import io.openbpm.bpm.engine.impl.core.instance.CoreExecution;
import io.openbpm.bpm.engine.impl.core.variable.event.VariableEvent;
import io.openbpm.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import io.openbpm.bpm.engine.impl.form.FormPropertyHelper;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.history.event.HistoryEvent;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventProcessor;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventTypes;
import io.openbpm.bpm.engine.impl.history.producer.HistoryEventProducer;
import io.openbpm.bpm.engine.impl.incident.IncidentContext;
import io.openbpm.bpm.engine.impl.incident.IncidentHandler;
import io.openbpm.bpm.engine.impl.incident.IncidentHandling;
import io.openbpm.bpm.engine.impl.persistence.entity.DelayedVariableEvent;
import io.openbpm.bpm.engine.impl.persistence.entity.IncidentEntity;
import io.openbpm.bpm.engine.impl.pvm.PvmActivity;
import io.openbpm.bpm.engine.impl.pvm.PvmException;
import io.openbpm.bpm.engine.impl.pvm.PvmExecution;
import io.openbpm.bpm.engine.impl.pvm.PvmLogger;
import io.openbpm.bpm.engine.impl.pvm.PvmProcessDefinition;
import io.openbpm.bpm.engine.impl.pvm.PvmProcessInstance;
import io.openbpm.bpm.engine.impl.pvm.PvmScope;
import io.openbpm.bpm.engine.impl.pvm.PvmTransition;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityExecution;
import io.openbpm.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import io.openbpm.bpm.engine.impl.pvm.delegate.ModificationObserverBehavior;
import io.openbpm.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityStartBehavior;
import io.openbpm.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.impl.pvm.process.TransitionImpl;
import io.openbpm.bpm.engine.impl.pvm.runtime.ActivityInstanceState;
import io.openbpm.bpm.engine.impl.pvm.runtime.Callback;
import io.openbpm.bpm.engine.impl.pvm.runtime.CompensationBehavior;
import io.openbpm.bpm.engine.impl.pvm.runtime.InstantiationStack;
import io.openbpm.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import io.openbpm.bpm.engine.impl.pvm.runtime.ScopeInstantiationContext;
import io.openbpm.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import io.openbpm.bpm.engine.impl.tree.ExecutionWalker;
import io.openbpm.bpm.engine.impl.tree.FlowScopeWalker;
import io.openbpm.bpm.engine.impl.tree.LeafActivityInstanceExecutionCollector;
import io.openbpm.bpm.engine.impl.tree.ScopeCollector;
import io.openbpm.bpm.engine.impl.tree.ScopeExecutionCollector;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.runtime.Incident;
import io.openbpm.bpm.engine.variable.VariableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class PvmExecutionImpl
extends CoreExecution
implements ActivityExecution,
PvmProcessInstance {
    private static final long serialVersionUID = 1L;
    private static final PvmLogger LOG = ProcessEngineLogger.PVM_LOGGER;
    protected transient ProcessDefinitionImpl processDefinition;
    protected transient ScopeInstantiationContext scopeInstantiationContext;
    protected transient boolean ignoreAsync;
    protected transient boolean isStarting;
    protected transient ActivityImpl activity;
    protected transient PvmActivity nextActivity;
    protected transient TransitionImpl transition;
    protected transient List<PvmTransition> transitionsToTake;
    protected String activityInstanceId;
    protected String caseInstanceId;
    protected PvmExecutionImpl replacedBy;
    protected boolean deleteRoot;
    protected String deleteReason;
    protected boolean externallyTerminated;
    protected boolean isActive = true;
    protected boolean isScope = true;
    protected boolean isConcurrent;
    protected boolean isEnded;
    protected boolean isEventScope;
    protected boolean isRemoved;
    protected boolean preserveScope;
    protected int activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    protected boolean activityInstanceEndListenersFailed;
    protected Map<String, Object> payloadForTriggeredScope;
    protected long sequenceCounter;
    protected transient List<DelayedVariableEvent> delayedEvents = new ArrayList<DelayedVariableEvent>();

    protected PvmExecutionImpl() {
    }

    @Override
    public abstract PvmExecutionImpl createExecution();

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey) {
        PvmExecutionImpl processInstance = this.getProcessInstance();
        String caseId = null;
        if (processInstance != null) {
            caseId = processInstance.getCaseInstanceId();
        }
        return this.createSubProcessInstance(processDefinition, businessKey, caseId);
    }

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey, String caseInstanceId) {
        PvmExecutionImpl subProcessInstance = this.newExecution();
        subProcessInstance.setSuperExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        subProcessInstance.setProcessDefinition((ProcessDefinitionImpl)processDefinition);
        subProcessInstance.setProcessInstance(subProcessInstance);
        subProcessInstance.setActivity(processDefinition.getInitial());
        if (businessKey != null) {
            subProcessInstance.setBusinessKey(businessKey);
        }
        if (caseInstanceId != null) {
            subProcessInstance.setCaseInstanceId(caseInstanceId);
        }
        return subProcessInstance;
    }

    protected abstract PvmExecutionImpl newExecution();

    @Override
    public abstract CmmnExecution createSubCaseInstance(CmmnCaseDefinition var1);

    @Override
    public abstract CmmnExecution createSubCaseInstance(CmmnCaseDefinition var1, String var2);

    public abstract void initialize();

    public abstract void initializeTimerDeclarations();

    public void executeIoMapping() {
        ActivityImpl currentActivity;
        ScopeImpl currentScope = this.getScopeActivity();
        if (currentScope != currentScope.getProcessDefinition() && (currentActivity = (ActivityImpl)currentScope).getIoMapping() != null && !this.skipIoMapping) {
            currentActivity.getIoMapping().executeInputParameters(this);
        }
    }

    @Override
    public void start() {
        this.start(null);
    }

    @Override
    public void start(Map<String, Object> variables) {
        this.start(variables, null);
    }

    public void startWithFormProperties(VariableMap formProperties) {
        this.start(null, formProperties);
    }

    protected void start(Map<String, Object> variables, VariableMap formProperties) {
        this.initialize();
        this.fireHistoricProcessStartEvent();
        if (variables != null) {
            this.setVariables(variables);
        }
        if (formProperties != null) {
            FormPropertyHelper.initFormPropertiesOnScope(formProperties, this);
        }
        this.initializeTimerDeclarations();
        this.performOperation(PvmAtomicOperation.PROCESS_START);
    }

    public void startWithoutExecuting(Map<String, Object> variables) {
        this.initialize();
        this.fireHistoricProcessStartEvent();
        this.setActivityInstanceId(this.getId());
        this.setVariables(variables);
        this.initializeTimerDeclarations();
        this.performOperation(PvmAtomicOperation.FIRE_PROCESS_START);
        this.setActivity(null);
    }

    public abstract void fireHistoricProcessStartEvent();

    @Override
    public void destroy() {
        this.destroy(false);
    }

    public void destroy(boolean alwaysSkipIoMappings) {
        LOG.destroying(this);
        this.setScope(false);
    }

    public void removeAllTasks() {
    }

    protected void removeEventScopes() {
        ArrayList<? extends PvmExecutionImpl> childExecutions = new ArrayList<PvmExecutionImpl>(this.getEventScopeExecutions());
        for (PvmExecutionImpl pvmExecutionImpl : childExecutions) {
            LOG.removingEventScope(pvmExecutionImpl);
            pvmExecutionImpl.destroy();
            pvmExecutionImpl.remove();
        }
    }

    public void clearScope(String reason, boolean skipCustomListeners, boolean skipIoMappings, boolean externallyTerminated) {
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMapping = skipIoMappings;
        if (this.getSubProcessInstance() != null) {
            this.getSubProcessInstance().deleteCascade(reason, skipCustomListeners, skipIoMappings, externallyTerminated, false);
        }
        ArrayList<? extends PvmExecutionImpl> executions = new ArrayList<PvmExecutionImpl>(this.getNonEventScopeExecutions());
        for (PvmExecutionImpl pvmExecutionImpl : executions) {
            if (pvmExecutionImpl.getSubProcessInstance() != null) {
                pvmExecutionImpl.getSubProcessInstance().deleteCascade(reason, skipCustomListeners, skipIoMappings, externallyTerminated, false);
            }
            pvmExecutionImpl.deleteCascade(reason, skipCustomListeners, skipIoMappings, externallyTerminated, false);
        }
        ActivityImpl pvmActivity = this.getActivity();
        if ((this.isActive || externallyTerminated) && pvmActivity != null) {
            if (this.activityInstanceState != ActivityInstanceState.ENDING.getStateCode() || this.activityInstanceEndListenersFailed) {
                this.setCanceled(true);
                this.performOperation(PvmAtomicOperation.FIRE_ACTIVITY_END);
            }
            this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
        }
    }

    @Override
    public void interrupt(String reason) {
        this.interrupt(reason, false, false, false);
    }

    public void interrupt(String reason, boolean skipCustomListeners, boolean skipIoMappings, boolean externallyTerminated) {
        LOG.interruptingExecution(reason, skipCustomListeners);
        this.clearScope(reason, skipCustomListeners, skipIoMappings, externallyTerminated);
    }

    @Override
    public void end(boolean completeScope) {
        this.setCompleteScope(completeScope);
        this.isActive = false;
        this.isEnded = true;
        if (this.hasReplacedParent()) {
            this.getParent().replacedBy = null;
        }
        this.performOperation(PvmAtomicOperation.ACTIVITY_NOTIFY_LISTENER_END);
    }

    @Override
    public void endCompensation() {
        this.performOperation(PvmAtomicOperation.FIRE_ACTIVITY_END);
        this.remove();
        PvmExecutionImpl parent = this.getParent();
        if (parent.getActivity() == null) {
            parent.setActivity((PvmActivity)((Object)this.getActivity().getFlowScope()));
        }
        parent.signal("compensationDone", null);
    }

    public void propagateEnd() {
        if (!this.isEnded()) {
            throw new ProcessEngineException(this.toString() + " must have ended before ending can be propagated");
        }
        if (this.isProcessInstanceExecution()) {
            this.performOperation(PvmAtomicOperation.PROCESS_END);
        }
    }

    @Override
    public void remove() {
        PvmExecutionImpl parent = this.getParent();
        if (parent != null) {
            parent.getExecutions().remove(this);
            long parentSequenceCounter = parent.getSequenceCounter();
            long mySequenceCounter = this.getSequenceCounter();
            if (mySequenceCounter > parentSequenceCounter) {
                parent.setSequenceCounter(mySequenceCounter);
            }
            parent.skipCustomListeners |= this.skipCustomListeners;
            parent.skipIoMapping |= this.skipIoMapping;
        }
        this.isActive = false;
        this.isEnded = true;
        this.isRemoved = true;
        if (this.hasReplacedParent()) {
            this.getParent().replacedBy = null;
        }
        this.removeEventScopes();
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public PvmExecutionImpl createConcurrentExecution() {
        if (!this.isScope()) {
            throw new ProcessEngineException("Cannot create concurrent execution for " + this);
        }
        List<? extends PvmExecutionImpl> children = this.getNonEventScopeExecutions();
        this.forceUpdate();
        if (children.isEmpty()) {
            PvmExecutionImpl replacingExecution = this.createExecution();
            replacingExecution.setConcurrent(true);
            replacingExecution.setScope(false);
            replacingExecution.replace(this);
            this.inactivate();
            this.setActivity(null);
        } else if (children.size() == 1) {
            PvmExecutionImpl child = children.get(0);
            PvmExecutionImpl concurrentReplacingExecution = this.createExecution();
            concurrentReplacingExecution.setConcurrent(true);
            concurrentReplacingExecution.setScope(false);
            concurrentReplacingExecution.setActive(false);
            concurrentReplacingExecution.onConcurrentExpand(this);
            child.setParent(concurrentReplacingExecution);
            this.leaveActivityInstance();
            this.setActivity(null);
        }
        PvmExecutionImpl concurrentExecution = this.createExecution();
        concurrentExecution.setConcurrent(true);
        concurrentExecution.setScope(false);
        return concurrentExecution;
    }

    @Override
    public boolean tryPruneLastConcurrentChild() {
        PvmExecutionImpl lastConcurrent;
        if (this.getNonEventScopeExecutions().size() == 1 && (lastConcurrent = this.getNonEventScopeExecutions().get(0)).isConcurrent()) {
            if (!lastConcurrent.isScope()) {
                this.setActivity(lastConcurrent.getActivity());
                this.setTransition(lastConcurrent.getTransition());
                this.replace(lastConcurrent);
                if (lastConcurrent.hasChildren()) {
                    for (PvmExecutionImpl pvmExecutionImpl : lastConcurrent.getExecutionsAsCopy()) {
                        pvmExecutionImpl.setParent(this);
                    }
                }
                if (!this.isActive() && lastConcurrent.isActive()) {
                    this.setActive(true);
                }
                lastConcurrent.remove();
            } else {
                LegacyBehavior.pruneConcurrentScope(lastConcurrent);
            }
            return true;
        }
        return false;
    }

    @Override
    public void deleteCascade(String deleteReason) {
        this.deleteCascade(deleteReason, false, false);
    }

    public void deleteCascade(String deleteReason, boolean skipCustomListeners, boolean skipIoMappings) {
        this.deleteCascade(deleteReason, skipCustomListeners, skipIoMappings, false, false);
    }

    public void deleteCascade(String deleteReason, boolean skipCustomListeners, boolean skipIoMappings, boolean externallyTerminated, boolean skipSubprocesses) {
        this.deleteReason = deleteReason;
        this.setDeleteRoot(true);
        this.isEnded = true;
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMapping = skipIoMappings;
        this.externallyTerminated = externallyTerminated;
        this.skipSubprocesses = skipSubprocesses;
        this.performOperation(PvmAtomicOperation.DELETE_CASCADE);
    }

    public void executeEventHandlerActivity(ActivityImpl eventHandlerActivity) {
        ScopeImpl flowScope = eventHandlerActivity.getFlowScope();
        ScopeImpl eventScope = eventHandlerActivity.getEventScope();
        if (eventHandlerActivity.getActivityStartBehavior() == ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE && flowScope != eventScope) {
            this.findExecutionForScope(eventScope, flowScope).executeActivity(eventHandlerActivity);
        } else {
            this.executeActivity(eventHandlerActivity);
        }
    }

    public abstract PvmExecutionImpl getReplacedBy();

    public PvmExecutionImpl resolveReplacedBy() {
        PvmExecutionImpl secondHopReplacingExecution;
        PvmExecutionImpl replacingExecution = this.getReplacedBy();
        if (replacingExecution != null && (secondHopReplacingExecution = replacingExecution.getReplacedBy()) != null) {
            replacingExecution = secondHopReplacingExecution;
        }
        return replacingExecution;
    }

    public boolean hasReplacedParent() {
        return this.getParent() != null && this.getParent().getReplacedBy() == this;
    }

    public boolean isReplacedByParent() {
        return this.getReplacedBy() != null && this.getReplacedBy() == this.getParent();
    }

    public void replace(PvmExecutionImpl execution) {
        this.activityInstanceId = execution.getActivityInstanceId();
        this.isActive = execution.isActive;
        this.replacedBy = null;
        execution.replacedBy = this;
        this.transitionsToTake = execution.transitionsToTake;
        execution.leaveActivityInstance();
    }

    public void onConcurrentExpand(PvmExecutionImpl scopeExecution) {
    }

    @Override
    public void signal(String signalName, Object signalData) {
        if (this.getActivity() == null) {
            throw new PvmException("cannot signal execution " + this.id + ": it has no current activity");
        }
        SignallableActivityBehavior activityBehavior = (SignallableActivityBehavior)this.activity.getActivityBehavior();
        try {
            activityBehavior.signal(this, signalName, signalData);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't process signal '" + signalName + "' on activity '" + this.activity.getId() + "': " + e.getMessage(), e);
        }
    }

    public void take() {
        if (this.transition == null) {
            throw new PvmException(this.toString() + ": no transition to take specified");
        }
        TransitionImpl transitionImpl = this.transition;
        this.setActivity(transitionImpl.getSource());
        this.setActivityInstanceId(null);
        this.setActive(true);
        this.performOperation(PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE);
    }

    @Override
    public void executeActivity(PvmActivity activity) {
        if (!activity.getIncomingTransitions().isEmpty()) {
            throw new ProcessEngineException("Activity is contained in normal flow and cannot be executed using executeActivity().");
        }
        ActivityStartBehavior activityStartBehavior = activity.getActivityStartBehavior();
        if (!this.isScope() && ActivityStartBehavior.DEFAULT != activityStartBehavior) {
            throw new ProcessEngineException("Activity '" + activity + "' with start behavior '" + activityStartBehavior + "'cannot be executed by non-scope execution.");
        }
        PvmActivity activityImpl = activity;
        this.isEnded = false;
        this.isActive = true;
        switch (activityStartBehavior) {
            case CONCURRENT_IN_FLOW_SCOPE: {
                this.nextActivity = activityImpl;
                this.performOperation(PvmAtomicOperation.ACTIVITY_START_CONCURRENT);
                break;
            }
            case CANCEL_EVENT_SCOPE: {
                this.nextActivity = activityImpl;
                this.performOperation(PvmAtomicOperation.ACTIVITY_START_CANCEL_SCOPE);
                break;
            }
            case INTERRUPT_EVENT_SCOPE: {
                this.nextActivity = activityImpl;
                this.performOperation(PvmAtomicOperation.ACTIVITY_START_INTERRUPT_SCOPE);
                break;
            }
            default: {
                this.setActivity(activityImpl);
                this.setActivityInstanceId(null);
                this.setDelayedPayloadToNewScope(activity);
                this.performOperation(PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE);
            }
        }
    }

    protected void setDelayedPayloadToNewScope(PvmActivity activity) {
        String activityType = (String)activity.getProperty(BpmnProperties.TYPE.name());
        if (("messageStartEvent".equals(activityType) || "boundaryMessage".equals(activityType)) && this.getProcessInstance().getPayloadForTriggeredScope() != null) {
            this.setVariablesLocal(this.getProcessInstance().getPayloadForTriggeredScope());
            this.getProcessInstance().setPayloadForTriggeredScope(null);
        }
    }

    public void executeActivitiesConcurrent(List<PvmActivity> activityStack, PvmActivity targetActivity, PvmTransition targetTransition, Map<String, Object> variables, Map<String, Object> localVariables, boolean skipCustomListeners, boolean skipIoMappings) {
        ScopeImpl flowScope = null;
        if (!activityStack.isEmpty()) {
            flowScope = activityStack.get(0).getFlowScope();
        } else if (targetActivity != null) {
            flowScope = targetActivity.getFlowScope();
        } else if (targetTransition != null) {
            flowScope = targetTransition.getSource().getFlowScope();
        }
        PvmExecutionImpl propagatingExecution = null;
        CoreActivityBehavior<? extends BaseDelegateExecution> coreActivityBehavior = flowScope.getActivityBehavior();
        if (coreActivityBehavior instanceof ModificationObserverBehavior) {
            ModificationObserverBehavior flowScopeBehavior = (ModificationObserverBehavior)coreActivityBehavior;
            propagatingExecution = (PvmExecutionImpl)flowScopeBehavior.createInnerInstance(this);
        } else {
            propagatingExecution = this.createConcurrentExecution();
        }
        propagatingExecution.executeActivities(activityStack, targetActivity, targetTransition, variables, localVariables, skipCustomListeners, skipIoMappings);
    }

    public Map<PvmActivity, PvmExecutionImpl> instantiateScopes(List<PvmActivity> activityStack, boolean skipCustomListeners, boolean skipIoMappings) {
        if (activityStack.isEmpty()) {
            return Collections.emptyMap();
        }
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMapping = skipIoMappings;
        ScopeInstantiationContext executionStartContext = new ScopeInstantiationContext();
        InstantiationStack instantiationStack = new InstantiationStack(new LinkedList<PvmActivity>(activityStack));
        executionStartContext.setInstantiationStack(instantiationStack);
        this.setStartContext(executionStartContext);
        this.performOperation(PvmAtomicOperation.ACTIVITY_INIT_STACK_AND_RETURN);
        HashMap<PvmActivity, PvmExecutionImpl> createdExecutions = new HashMap<PvmActivity, PvmExecutionImpl>();
        PvmExecutionImpl currentExecution = this;
        for (PvmActivity instantiatedActivity : activityStack) {
            if ((currentExecution = currentExecution.getNonEventScopeExecutions().get(0)).isConcurrent()) {
                currentExecution = currentExecution.getNonEventScopeExecutions().get(0);
            }
            createdExecutions.put(instantiatedActivity, currentExecution);
        }
        return createdExecutions;
    }

    public void executeActivities(List<PvmActivity> activityStack, PvmActivity targetActivity, PvmTransition targetTransition, Map<String, Object> variables, Map<String, Object> localVariables, boolean skipCustomListeners, boolean skipIoMappings) {
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMapping = skipIoMappings;
        this.activityInstanceId = null;
        this.isEnded = false;
        if (!activityStack.isEmpty()) {
            ScopeInstantiationContext executionStartContext = new ScopeInstantiationContext();
            InstantiationStack instantiationStack = new InstantiationStack(activityStack, targetActivity, targetTransition);
            executionStartContext.setInstantiationStack(instantiationStack);
            executionStartContext.setVariables(variables);
            executionStartContext.setVariablesLocal(localVariables);
            this.setStartContext(executionStartContext);
            this.performOperation(PvmAtomicOperation.ACTIVITY_INIT_STACK);
        } else if (targetActivity != null) {
            this.setVariables(variables);
            this.setVariablesLocal(localVariables);
            this.setActivity(targetActivity);
            this.performOperation(PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE);
        } else if (targetTransition != null) {
            this.setVariables(variables);
            this.setVariablesLocal(localVariables);
            this.setActivity(targetTransition.getSource());
            this.setTransition(targetTransition);
            this.performOperation(PvmAtomicOperation.TRANSITION_START_NOTIFY_LISTENER_TAKE);
        }
    }

    @Override
    public List<ActivityExecution> findInactiveConcurrentExecutions(PvmActivity activity) {
        ArrayList<ActivityExecution> inactiveConcurrentExecutionsInActivity = new ArrayList<ActivityExecution>();
        if (this.isConcurrent()) {
            return this.getParent().findInactiveChildExecutions(activity);
        }
        if (!this.isActive()) {
            inactiveConcurrentExecutionsInActivity.add(this);
        }
        return inactiveConcurrentExecutionsInActivity;
    }

    @Override
    public List<ActivityExecution> findInactiveChildExecutions(PvmActivity activity) {
        ArrayList<ActivityExecution> inactiveConcurrentExecutionsInActivity = new ArrayList<ActivityExecution>();
        List<PvmExecutionImpl> concurrentExecutions = this.getAllChildExecutions();
        for (PvmExecutionImpl concurrentExecution : concurrentExecutions) {
            if (concurrentExecution.getActivity() != activity || concurrentExecution.isActive()) continue;
            inactiveConcurrentExecutionsInActivity.add(concurrentExecution);
        }
        return inactiveConcurrentExecutionsInActivity;
    }

    protected List<PvmExecutionImpl> getAllChildExecutions() {
        ArrayList<PvmExecutionImpl> childExecutions = new ArrayList<PvmExecutionImpl>();
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            childExecutions.add(pvmExecutionImpl);
            childExecutions.addAll(pvmExecutionImpl.getAllChildExecutions());
        }
        return childExecutions;
    }

    @Override
    public void leaveActivityViaTransition(PvmTransition outgoingTransition) {
        this.leaveActivityViaTransitions(Arrays.asList(outgoingTransition), Collections.emptyList());
    }

    @Override
    public void leaveActivityViaTransitions(List<PvmTransition> transitions, List<? extends ActivityExecution> recyclableExecutions) {
        if ((recyclableExecutions = recyclableExecutions != null ? new ArrayList<ActivityExecution>(recyclableExecutions) : new ArrayList<ActivityExecution>()).size() > 1) {
            this.removeVariablesLocalInternal();
        }
        for (ActivityExecution activityExecution : recyclableExecutions) {
            activityExecution.setEnded(true);
        }
        recyclableExecutions.remove(this);
        for (ActivityExecution activityExecution : recyclableExecutions) {
            activityExecution.setIgnoreAsync(true);
            activityExecution.end(transitions.isEmpty());
        }
        PvmExecutionImpl propagatingExecution = this;
        if (this.getReplacedBy() != null) {
            propagatingExecution = this.getReplacedBy();
        }
        propagatingExecution.isActive = true;
        propagatingExecution.isEnded = false;
        if (transitions.isEmpty()) {
            propagatingExecution.end(!propagatingExecution.isConcurrent());
        } else {
            propagatingExecution.setTransitionsToTake(transitions);
            propagatingExecution.performOperation(PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_END);
        }
    }

    protected abstract void removeVariablesLocalInternal();

    public boolean isActive(String activityId) {
        return this.findExecution(activityId) != null;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    public abstract List<? extends PvmExecutionImpl> getExecutions();

    public abstract List<? extends PvmExecutionImpl> getExecutionsAsCopy();

    public List<? extends PvmExecutionImpl> getNonEventScopeExecutions() {
        List<? extends PvmExecutionImpl> children = this.getExecutions();
        ArrayList<PvmExecutionImpl> result = new ArrayList<PvmExecutionImpl>();
        for (PvmExecutionImpl pvmExecutionImpl : children) {
            if (pvmExecutionImpl.isEventScope()) continue;
            result.add(pvmExecutionImpl);
        }
        return result;
    }

    public List<? extends PvmExecutionImpl> getEventScopeExecutions() {
        List<? extends PvmExecutionImpl> children = this.getExecutions();
        ArrayList<PvmExecutionImpl> result = new ArrayList<PvmExecutionImpl>();
        for (PvmExecutionImpl pvmExecutionImpl : children) {
            if (!pvmExecutionImpl.isEventScope()) continue;
            result.add(pvmExecutionImpl);
        }
        return result;
    }

    @Override
    public PvmExecutionImpl findExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            PvmExecutionImpl result = pvmExecutionImpl.findExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<PvmExecution> findExecutions(String activityId) {
        ArrayList<PvmExecution> matchingExecutions = new ArrayList<PvmExecution>();
        this.collectExecutions(activityId, matchingExecutions);
        return matchingExecutions;
    }

    protected void collectExecutions(String activityId, List<PvmExecution> executions) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            executions.add(this);
        }
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            pvmExecutionImpl.collectExecutions(activityId, executions);
        }
    }

    @Override
    public List<String> findActiveActivityIds() {
        ArrayList<String> activeActivityIds = new ArrayList<String>();
        this.collectActiveActivityIds(activeActivityIds);
        return activeActivityIds;
    }

    protected void collectActiveActivityIds(List<String> activeActivityIds) {
        ActivityImpl act = this.getActivity();
        if (this.isActive && act != null) {
            activeActivityIds.add(act.getId());
        }
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            pvmExecutionImpl.collectActiveActivityIds(activeActivityIds);
        }
    }

    @Override
    public String getProcessBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public void setProcessBusinessKey(String businessKey) {
        final PvmExecutionImpl processInstance = this.getProcessInstance();
        processInstance.setBusinessKey(businessKey);
        HistoryLevel historyLevel = Context.getCommandContext().getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_UPDATE, processInstance)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createProcessInstanceUpdateEvt(processInstance);
                }
            });
        }
    }

    @Override
    public String getBusinessKey() {
        if (this.isProcessInstanceExecution()) {
            return this.businessKey;
        }
        return this.getProcessBusinessKey();
    }

    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
    }

    public ProcessDefinitionImpl getProcessDefinition() {
        return this.processDefinition;
    }

    @Override
    public abstract PvmExecutionImpl getProcessInstance();

    public abstract void setProcessInstance(PvmExecutionImpl var1);

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @Override
    public ActivityImpl getActivity() {
        return this.activity;
    }

    public String getActivityId() {
        ActivityImpl act = this.getActivity();
        if (act != null) {
            return act.getId();
        }
        return null;
    }

    @Override
    public String getCurrentActivityName() {
        ActivityImpl act = this.getActivity();
        if (act != null) {
            return act.getName();
        }
        return null;
    }

    @Override
    public String getCurrentActivityId() {
        return this.getActivityId();
    }

    @Override
    public void setActivity(PvmActivity activity) {
        this.activity = (ActivityImpl)activity;
    }

    @Override
    public void enterActivityInstance() {
        ActivityImpl act = this.getActivity();
        this.activityInstanceId = this.generateActivityInstanceId(act.getId());
        LOG.debugEnterActivityInstance(this, this.getParentActivityInstanceId());
        this.executeIoMapping();
        if (act.isScope()) {
            this.initializeTimerDeclarations();
        }
        this.activityInstanceEndListenersFailed = false;
    }

    public void activityInstanceStarting() {
        this.activityInstanceState = ActivityInstanceState.STARTING.getStateCode();
    }

    public void activityInstanceStarted() {
        this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    }

    public void activityInstanceDone() {
        this.activityInstanceState = ActivityInstanceState.ENDING.getStateCode();
    }

    public void activityInstanceEndListenerFailure() {
        this.activityInstanceEndListenersFailed = true;
    }

    protected abstract String generateActivityInstanceId(String var1);

    @Override
    public void leaveActivityInstance() {
        if (this.activityInstanceId != null) {
            LOG.debugLeavesActivityInstance(this, this.activityInstanceId);
        }
        this.activityInstanceId = this.getParentActivityInstanceId();
        this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
        this.activityInstanceEndListenersFailed = false;
    }

    @Override
    public String getParentActivityInstanceId() {
        if (this.isProcessInstanceExecution()) {
            return this.getId();
        }
        return this.getParent().getActivityInstanceId();
    }

    @Override
    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    @Override
    public abstract PvmExecutionImpl getParent();

    @Override
    public String getParentId() {
        PvmExecutionImpl parent = this.getParent();
        if (parent != null) {
            return parent.getId();
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return !this.getExecutions().isEmpty();
    }

    public void setParent(PvmExecutionImpl parent) {
        PvmExecutionImpl currentParent = this.getParent();
        this.setParentExecution(parent);
        if (currentParent != null) {
            currentParent.getExecutions().remove(this);
        }
        if (parent != null) {
            parent.getExecutions().add(this);
        }
    }

    public abstract void setParentExecution(PvmExecutionImpl var1);

    @Override
    public abstract PvmExecutionImpl getSuperExecution();

    public abstract void setSuperExecution(PvmExecutionImpl var1);

    public abstract PvmExecutionImpl getSubProcessInstance();

    public abstract void setSubProcessInstance(PvmExecutionImpl var1);

    public abstract CmmnExecution getSuperCaseExecution();

    public abstract void setSuperCaseExecution(CmmnExecution var1);

    public abstract CmmnExecution getSubCaseInstance();

    public abstract void setSubCaseInstance(CmmnExecution var1);

    protected ScopeImpl getScopeActivity() {
        ScopeImpl scope = null;
        scope = this.isProcessInstanceExecution() ? this.getProcessDefinition() : this.getActivity();
        return scope;
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public PvmExecutionImpl findExecutionForFlowScope(PvmScope targetFlowScope) {
        PvmExecutionImpl scopeExecution = this.isScope() ? this : this.getParent();
        ActivityImpl currentActivity = this.getActivity();
        EnsureUtil.ensureNotNull("activity of current execution", (Object)currentActivity);
        currentActivity = currentActivity.isScope() ? currentActivity : currentActivity.getFlowScope();
        return scopeExecution.findExecutionForScope(currentActivity, (ScopeImpl)targetFlowScope);
    }

    public PvmExecutionImpl findExecutionForScope(ScopeImpl currentScope, ScopeImpl targetScope) {
        if (!targetScope.isScope()) {
            throw new ProcessEngineException("Target scope must be a scope.");
        }
        Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = this.createActivityExecutionMapping(currentScope);
        PvmExecutionImpl scopeExecution = activityExecutionMapping.get(targetScope);
        if (scopeExecution == null) {
            scopeExecution = LegacyBehavior.getScopeExecution(targetScope, activityExecutionMapping);
        }
        return scopeExecution;
    }

    public Map<ScopeImpl, PvmExecutionImpl> createActivityExecutionMapping(ScopeImpl currentScope) {
        if (!this.isScope()) {
            throw new ProcessEngineException("Execution must be a scope execution");
        }
        if (!currentScope.isScope()) {
            throw new ProcessEngineException("Current scope must be a scope.");
        }
        LeafActivityInstanceExecutionCollector leafCollector = new LeafActivityInstanceExecutionCollector();
        new ExecutionWalker(this).addPreVisitor(leafCollector).walkUntil();
        List<PvmExecutionImpl> leaves = leafCollector.getLeaves();
        leaves.remove(this);
        Collections.reverse(leaves);
        Map<ScopeImpl, PvmExecutionImpl> mapping = new HashMap<ScopeImpl, PvmExecutionImpl>();
        for (PvmExecutionImpl leaf : leaves) {
            ScopeImpl leafFlowScope = leaf.getFlowScope();
            PvmExecutionImpl leafFlowScopeExecution = leaf.getFlowScopeExecution();
            mapping = leafFlowScopeExecution.createActivityExecutionMapping(leafFlowScope, mapping);
        }
        return this.createActivityExecutionMapping(currentScope, mapping);
    }

    @Override
    public Map<ScopeImpl, PvmExecutionImpl> createActivityExecutionMapping() {
        ActivityImpl currentActivity = this.getActivity();
        EnsureUtil.ensureNotNull("activity of current execution", (Object)currentActivity);
        ScopeImpl flowScope = this.getFlowScope();
        PvmExecutionImpl flowScopeExecution = this.getFlowScopeExecution();
        return flowScopeExecution.createActivityExecutionMapping(flowScope);
    }

    protected PvmExecutionImpl getFlowScopeExecution() {
        if (!this.isScope || CompensationBehavior.executesNonScopeCompensationHandler(this) || this.isAsyncAfterScopeWithoutTransition()) {
            return this.getParent().getFlowScopeExecution();
        }
        return this;
    }

    protected ScopeImpl getFlowScope() {
        ActivityImpl act = this.getActivity();
        if (!act.isScope() || this.activityInstanceId == null || act.isScope() && !this.isScope() && act.getActivityBehavior() instanceof CompositeActivityBehavior) {
            return act.getFlowScope();
        }
        return act;
    }

    protected Map<ScopeImpl, PvmExecutionImpl> createActivityExecutionMapping(ScopeImpl currentScope, Map<ScopeImpl, PvmExecutionImpl> mapping) {
        if (!this.isScope()) {
            throw new ProcessEngineException("Execution must be a scope execution");
        }
        if (!currentScope.isScope()) {
            throw new ProcessEngineException("Current scope must be a scope.");
        }
        ScopeExecutionCollector scopeExecutionCollector = new ScopeExecutionCollector();
        new ExecutionWalker(this).addPreVisitor(scopeExecutionCollector).walkWhile(element -> element == null || mapping.containsValue(element));
        List<PvmExecutionImpl> scopeExecutions = scopeExecutionCollector.getScopeExecutions();
        ScopeCollector scopeCollector = new ScopeCollector();
        new FlowScopeWalker(currentScope).addPreVisitor(scopeCollector).walkWhile(element -> element == null || mapping.containsKey(element));
        List<ScopeImpl> scopes = scopeCollector.getScopes();
        ScopeImpl topMostScope = scopes.get(scopes.size() - 1);
        new FlowScopeWalker(topMostScope.getFlowScope()).addPreVisitor(obj -> {
            scopes.add((ScopeImpl)obj);
            PvmExecutionImpl priorMappingExecution = (PvmExecutionImpl)mapping.get(obj);
            if (priorMappingExecution != null && !scopeExecutions.contains(priorMappingExecution)) {
                scopeExecutions.add(priorMappingExecution);
            }
        }).walkWhile();
        if (scopes.size() == scopeExecutions.size()) {
            HashMap<ScopeImpl, PvmExecutionImpl> result = new HashMap<ScopeImpl, PvmExecutionImpl>();
            for (int i = 0; i < scopes.size(); ++i) {
                result.put(scopes.get(i), scopeExecutions.get(i));
            }
            return result;
        }
        return LegacyBehavior.createActivityExecutionMapping(scopeExecutions, scopes);
    }

    public String toString() {
        if (this.isProcessInstanceExecution()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isConcurrent ? "Concurrent" : "") + (this.isScope ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return this.id;
    }

    @Override
    public String getVariableScopeKey() {
        return "execution";
    }

    @Override
    public AbstractVariableScope getParentVariableScope() {
        return this.getParent();
    }

    @Override
    public void setVariable(String variableName, Object value, String targetActivityId) {
        String activityId = this.getActivityId();
        if (activityId != null && Objects.equals(activityId, targetActivityId)) {
            this.setVariableLocal(variableName, value);
        } else {
            PvmExecutionImpl executionForFlowScope = this.findExecutionForFlowScope(targetActivityId);
            if (executionForFlowScope != null) {
                executionForFlowScope.setVariableLocal(variableName, value);
            }
        }
    }

    protected PvmExecutionImpl findExecutionForFlowScope(String targetScopeId) {
        EnsureUtil.ensureNotNull("target scope id", (Object)targetScopeId);
        ActivityImpl currentActivity = this.getActivity();
        EnsureUtil.ensureNotNull("activity of current execution", (Object)currentActivity);
        FlowScopeWalker walker = new FlowScopeWalker(currentActivity);
        ScopeImpl targetFlowScope = walker.walkUntil(scope -> scope == null || scope.getId().equals(targetScopeId));
        if (targetFlowScope == null) {
            throw LOG.scopeNotFoundException(targetScopeId, this.getId());
        }
        return this.findExecutionForFlowScope(targetFlowScope);
    }

    public long getSequenceCounter() {
        return this.sequenceCounter;
    }

    public void setSequenceCounter(long sequenceCounter) {
        this.sequenceCounter = sequenceCounter;
    }

    public void incrementSequenceCounter() {
        ++this.sequenceCounter;
    }

    public boolean isExternallyTerminated() {
        return this.externallyTerminated;
    }

    public void setExternallyTerminated(boolean externallyTerminated) {
        this.externallyTerminated = externallyTerminated;
    }

    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    public boolean isDeleteRoot() {
        return this.deleteRoot;
    }

    public void setDeleteRoot(boolean deleteRoot) {
        this.deleteRoot = deleteRoot;
    }

    @Override
    public TransitionImpl getTransition() {
        return this.transition;
    }

    public List<PvmTransition> getTransitionsToTake() {
        return this.transitionsToTake;
    }

    public void setTransitionsToTake(List<PvmTransition> transitionsToTake) {
        this.transitionsToTake = transitionsToTake;
    }

    @Override
    public String getCurrentTransitionId() {
        TransitionImpl trans = this.getTransition();
        if (trans != null) {
            return trans.getId();
        }
        return null;
    }

    public void setTransition(PvmTransition transition) {
        this.transition = (TransitionImpl)transition;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public void setEnded(boolean isEnded) {
        this.isEnded = isEnded;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public boolean isCanceled() {
        return ActivityInstanceState.CANCELED.getStateCode() == this.activityInstanceState;
    }

    public void setCanceled(boolean canceled) {
        if (canceled) {
            this.activityInstanceState = ActivityInstanceState.CANCELED.getStateCode();
        }
    }

    @Override
    public boolean isCompleteScope() {
        return ActivityInstanceState.SCOPE_COMPLETE.getStateCode() == this.activityInstanceState;
    }

    public void setCompleteScope(boolean completeScope) {
        if (completeScope && !this.isCanceled()) {
            this.activityInstanceState = ActivityInstanceState.SCOPE_COMPLETE.getStateCode();
        }
    }

    public void setPreserveScope(boolean preserveScope) {
        this.preserveScope = preserveScope;
    }

    public boolean isPreserveScope() {
        return this.preserveScope;
    }

    public int getActivityInstanceState() {
        return this.activityInstanceState;
    }

    public boolean isInState(ActivityInstanceState state) {
        return this.activityInstanceState == state.getStateCode();
    }

    @Override
    public boolean hasFailedOnEndListeners() {
        return this.activityInstanceEndListenersFailed;
    }

    public boolean isEventScope() {
        return this.isEventScope;
    }

    public void setEventScope(boolean isEventScope) {
        this.isEventScope = isEventScope;
    }

    public ScopeInstantiationContext getScopeInstantiationContext() {
        return this.scopeInstantiationContext;
    }

    public void disposeScopeInstantiationContext() {
        this.scopeInstantiationContext = null;
        PvmExecutionImpl parent = this;
        while ((parent = parent.getParent()) != null && parent.scopeInstantiationContext != null) {
            parent.scopeInstantiationContext = null;
        }
    }

    @Override
    public PvmActivity getNextActivity() {
        return this.nextActivity;
    }

    @Override
    public boolean isProcessInstanceExecution() {
        return this.getParent() == null;
    }

    public void setStartContext(ScopeInstantiationContext startContext) {
        this.scopeInstantiationContext = startContext;
    }

    @Override
    public void setIgnoreAsync(boolean ignoreAsync) {
        this.ignoreAsync = ignoreAsync;
    }

    public boolean isIgnoreAsync() {
        return this.ignoreAsync;
    }

    public void setStarting(boolean isStarting) {
        this.isStarting = isStarting;
    }

    public boolean isStarting() {
        return this.isStarting;
    }

    public boolean isProcessInstanceStarting() {
        return this.getProcessInstance().isStarting();
    }

    public void setProcessInstanceStarting(boolean starting) {
        this.getProcessInstance().setStarting(starting);
    }

    public void setNextActivity(PvmActivity nextActivity) {
        this.nextActivity = nextActivity;
    }

    public Map<String, Object> getPayloadForTriggeredScope() {
        return this.payloadForTriggeredScope;
    }

    public void setPayloadForTriggeredScope(Map<String, Object> payloadForTriggeredScope) {
        this.payloadForTriggeredScope = payloadForTriggeredScope;
    }

    public PvmExecutionImpl getParentScopeExecution(boolean considerSuperExecution) {
        if (this.isProcessInstanceExecution()) {
            if (considerSuperExecution && this.getSuperExecution() != null) {
                PvmExecutionImpl superExecution = this.getSuperExecution();
                if (superExecution.isScope()) {
                    return superExecution;
                }
                return superExecution.getParent();
            }
            return null;
        }
        PvmExecutionImpl parent = this.getParent();
        if (parent.isScope()) {
            return parent;
        }
        return parent.getParent();
    }

    public void delayEvent(PvmExecutionImpl targetScope, VariableEvent variableEvent) {
        DelayedVariableEvent delayedVariableEvent = new DelayedVariableEvent(targetScope, variableEvent);
        this.delayEvent(delayedVariableEvent);
    }

    public void delayEvent(DelayedVariableEvent delayedVariableEvent) {
        Boolean hasConditionalEvents = this.getProcessDefinition().getProperties().get(BpmnProperties.HAS_CONDITIONAL_EVENTS);
        if (hasConditionalEvents == null || !hasConditionalEvents.equals(Boolean.TRUE)) {
            return;
        }
        if (this.isProcessInstanceExecution()) {
            this.delayedEvents.add(delayedVariableEvent);
        } else {
            this.getProcessInstance().delayEvent(delayedVariableEvent);
        }
    }

    public List<DelayedVariableEvent> getDelayedEvents() {
        if (this.isProcessInstanceExecution()) {
            return this.delayedEvents;
        }
        return this.getProcessInstance().getDelayedEvents();
    }

    public void clearDelayedEvents() {
        if (this.isProcessInstanceExecution()) {
            this.delayedEvents.clear();
        } else {
            this.getProcessInstance().clearDelayedEvents();
        }
    }

    public void dispatchDelayedEventsAndPerformOperation(PvmAtomicOperation atomicOperation) {
        this.dispatchDelayedEventsAndPerformOperation((PvmExecutionImpl param) -> {
            param.performOperation(atomicOperation);
            return null;
        });
    }

    public void dispatchDelayedEventsAndPerformOperation(Callback<PvmExecutionImpl, Void> continuation) {
        PvmExecutionImpl execution = this;
        if (execution.getDelayedEvents().isEmpty()) {
            this.continueExecutionIfNotCanceled(continuation, execution);
            return;
        }
        this.continueIfExecutionDoesNotAffectNextOperation(execution1 -> {
            this.dispatchScopeEvents((PvmExecutionImpl)execution1);
            return null;
        }, execution2 -> {
            this.continueExecutionIfNotCanceled(continuation, (PvmExecutionImpl)execution2);
            return null;
        }, execution);
    }

    public void continueIfExecutionDoesNotAffectNextOperation(Callback<PvmExecutionImpl, Void> dispatching, Callback<PvmExecutionImpl, Void> continuation, PvmExecutionImpl execution) {
        String lastActivityId = execution.getActivityId();
        String lastActivityInstanceId = this.getActivityInstanceId(execution);
        dispatching.callback(execution);
        execution = execution.getReplacedBy() != null ? execution.getReplacedBy() : execution;
        String currentActivityInstanceId = this.getActivityInstanceId(execution);
        String currentActivityId = execution.getActivityId();
        if (!execution.isCanceled() && this.isOnSameActivity(lastActivityInstanceId, lastActivityId, currentActivityInstanceId, currentActivityId)) {
            continuation.callback(execution);
        }
    }

    protected void continueExecutionIfNotCanceled(Callback<PvmExecutionImpl, Void> continuation, PvmExecutionImpl execution) {
        if (continuation != null && !execution.isCanceled()) {
            continuation.callback(execution);
        }
    }

    protected void dispatchScopeEvents(PvmExecutionImpl execution) {
        PvmExecutionImpl scopeExecution = execution.isScope() ? execution : execution.getParent();
        ArrayList<DelayedVariableEvent> delayedVariableEvents = new ArrayList<DelayedVariableEvent>(scopeExecution.getDelayedEvents());
        scopeExecution.clearDelayedEvents();
        HashMap<PvmExecutionImpl, String> activityInstanceIds = new HashMap<PvmExecutionImpl, String>();
        HashMap<PvmExecutionImpl, String> activityIds = new HashMap<PvmExecutionImpl, String>();
        this.initActivityIds(delayedVariableEvents, activityInstanceIds, activityIds);
        for (DelayedVariableEvent event : delayedVariableEvents) {
            PvmExecutionImpl targetScope = event.getTargetScope();
            PvmExecutionImpl replaced = targetScope.getReplacedBy() != null ? targetScope.getReplacedBy() : targetScope;
            this.dispatchOnSameActivity(targetScope, replaced, activityIds, activityInstanceIds, event);
        }
    }

    protected void initActivityIds(List<DelayedVariableEvent> delayedEvents, Map<PvmExecutionImpl, String> activityInstanceIds, Map<PvmExecutionImpl, String> activityIds) {
        for (DelayedVariableEvent event : delayedEvents) {
            PvmExecutionImpl targetScope = event.getTargetScope();
            String targetScopeActivityInstanceId = this.getActivityInstanceId(targetScope);
            activityInstanceIds.put(targetScope, targetScopeActivityInstanceId);
            activityIds.put(targetScope, targetScope.getActivityId());
        }
    }

    private void dispatchOnSameActivity(PvmExecutionImpl targetScope, PvmExecutionImpl replacedBy, Map<PvmExecutionImpl, String> activityIds, Map<PvmExecutionImpl, String> activityInstanceIds, DelayedVariableEvent delayedVariableEvent) {
        String currentActivityInstanceId = this.getActivityInstanceId(targetScope);
        String currentActivityId = targetScope.getActivityId();
        String lastActivityInstanceId = activityInstanceIds.get(targetScope);
        String lastActivityId = activityIds.get(targetScope);
        boolean onSameAct = this.isOnSameActivity(lastActivityInstanceId, lastActivityId, currentActivityInstanceId, currentActivityId);
        if (targetScope != replacedBy && !onSameAct) {
            currentActivityInstanceId = this.getActivityInstanceId(replacedBy);
            currentActivityId = replacedBy.getActivityId();
            onSameAct = this.isOnSameActivity(lastActivityInstanceId, lastActivityId, currentActivityInstanceId, currentActivityId);
        }
        if (onSameAct && this.isOnDispatchableState(targetScope)) {
            targetScope.dispatchEvent(delayedVariableEvent.getEvent());
        }
    }

    private boolean isOnDispatchableState(PvmExecutionImpl targetScope) {
        ActivityImpl targetActivity = targetScope.getActivity();
        return targetScope.getActivityId() == null || !targetActivity.isScope() || targetScope.isInState(ActivityInstanceState.DEFAULT);
    }

    private boolean isOnSameActivity(String lastActivityInstanceId, String lastActivityId, String currentActivityInstanceId, String currentActivityId) {
        return lastActivityInstanceId == null && Objects.equals(lastActivityInstanceId, currentActivityInstanceId) && lastActivityId.equals(currentActivityId) || lastActivityInstanceId != null && Objects.equals(lastActivityInstanceId, currentActivityInstanceId) && (lastActivityId == null || lastActivityId.equals(currentActivityId));
    }

    private String getActivityInstanceId(PvmExecutionImpl targetScope) {
        if (targetScope.isConcurrent()) {
            return targetScope.getActivityInstanceId();
        }
        ActivityImpl targetActivity = targetScope.getActivity();
        if (targetActivity != null && targetActivity.getActivities().isEmpty()) {
            return targetScope.getActivityInstanceId();
        }
        return targetScope.getParentActivityInstanceId();
    }

    @Override
    public Incident createIncident(String incidentType, String configuration) {
        return this.createIncident(incidentType, configuration, null);
    }

    @Override
    public Incident createIncident(String incidentType, String configuration, String message) {
        IncidentContext incidentContext = this.createIncidentContext(configuration);
        return IncidentHandling.createIncident(incidentType, incidentContext, message);
    }

    protected IncidentContext createIncidentContext(String configuration) {
        IncidentContext incidentContext = new IncidentContext();
        incidentContext.setTenantId(this.getTenantId());
        incidentContext.setProcessDefinitionId(this.getProcessDefinitionId());
        incidentContext.setExecutionId(this.getId());
        incidentContext.setActivityId(this.getActivityId());
        incidentContext.setConfiguration(configuration);
        return incidentContext;
    }

    @Override
    public void resolveIncident(String incidentId) {
        IncidentEntity incident = (IncidentEntity)Context.getCommandContext().getIncidentManager().findIncidentById(incidentId);
        IncidentContext incidentContext = new IncidentContext(incident);
        IncidentHandling.removeIncidents(incident.getIncidentType(), incidentContext, true);
    }

    public IncidentHandler findIncidentHandler(String incidentType) {
        Map<String, IncidentHandler> incidentHandlers = Context.getProcessEngineConfiguration().getIncidentHandlers();
        return incidentHandlers.get(incidentType);
    }

    public boolean isExecutingScopeLeafActivity() {
        return this.isActive && this.getActivity() != null && this.getActivity().isScope() && this.activityInstanceId != null && !(this.getActivity().getActivityBehavior() instanceof CompositeActivityBehavior);
    }

    public boolean isAsyncAfterScopeWithoutTransition() {
        return this.activityInstanceId == null && this.activity.isScope() && !this.isActive;
    }
}

