/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.pvm.runtime.operation;

import io.openbpm.bpm.engine.impl.bpmn.helper.BpmnProperties;
import io.openbpm.bpm.engine.impl.core.model.CoreModelElement;
import io.openbpm.bpm.engine.impl.pvm.PvmActivity;
import io.openbpm.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import io.openbpm.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import io.openbpm.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public abstract class PvmAtomicOperationCancelActivity
implements PvmAtomicOperation {
    @Override
    public void execute(PvmExecutionImpl execution) {
        PvmActivity cancellingActivity = execution.getNextActivity();
        execution.setNextActivity(null);
        execution.setActive(true);
        PvmExecutionImpl propagatingExecution = null;
        if (LegacyBehavior.isConcurrentScope(execution)) {
            LegacyBehavior.cancelConcurrentScope(execution, (PvmActivity)cancellingActivity.getEventScope());
            propagatingExecution = execution;
        } else {
            execution.deleteCascade("Cancel scope activity " + cancellingActivity + " executed.");
            propagatingExecution = execution.getParent();
        }
        propagatingExecution.setActivity(cancellingActivity);
        this.setDelayedPayloadToNewScope(propagatingExecution, (CoreModelElement)((Object)cancellingActivity));
        propagatingExecution.setActive(true);
        propagatingExecution.setEnded(false);
        this.activityCancelled(propagatingExecution);
    }

    protected abstract void activityCancelled(PvmExecutionImpl var1);

    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        return false;
    }

    protected void setDelayedPayloadToNewScope(PvmExecutionImpl execution, CoreModelElement scope) {
        PvmExecutionImpl processInstance;
        String activityType = (String)scope.getProperty(BpmnProperties.TYPE.name());
        if (("messageStartEvent".equals(activityType) || "boundaryMessage".equals(activityType)) && (processInstance = execution.getProcessInstance()).getPayloadForTriggeredScope() != null) {
            execution.setVariablesLocal(processInstance.getPayloadForTriggeredScope());
            processInstance.setPayloadForTriggeredScope(null);
        }
    }
}

