/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.pvm.runtime.operation;

import io.openbpm.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import io.openbpm.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class PvmAtomicOperationDeleteCascade
implements PvmAtomicOperation {
    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        return false;
    }

    @Override
    public boolean isAsyncCapable() {
        return false;
    }

    @Override
    public void execute(PvmExecutionImpl execution) {
        PvmExecutionImpl nextLeaf;
        do {
            PvmExecutionImpl subProcessInstance;
            if ((nextLeaf = this.findNextLeaf(execution)).isDeleteRoot() && nextLeaf.isRemoved()) {
                return;
            }
            PvmExecutionImpl deleteRoot = this.getDeleteRoot(execution);
            if (deleteRoot != null) {
                nextLeaf.setSkipCustomListeners(deleteRoot.isSkipCustomListeners());
                nextLeaf.setSkipIoMappings(deleteRoot.isSkipIoMappings());
                nextLeaf.setExternallyTerminated(deleteRoot.isExternallyTerminated());
            }
            if ((subProcessInstance = nextLeaf.getSubProcessInstance()) != null) {
                if (deleteRoot.isSkipSubprocesses()) {
                    subProcessInstance.setSuperExecution(null);
                } else {
                    subProcessInstance.deleteCascade(execution.getDeleteReason(), nextLeaf.isSkipCustomListeners(), nextLeaf.isSkipIoMappings(), nextLeaf.isExternallyTerminated(), nextLeaf.isSkipSubprocesses());
                }
            }
            nextLeaf.performOperation(DELETE_CASCADE_FIRE_ACTIVITY_END);
        } while (!nextLeaf.isDeleteRoot());
    }

    protected PvmExecutionImpl findNextLeaf(PvmExecutionImpl execution) {
        if (execution.hasChildren()) {
            return this.findNextLeaf(execution.getExecutions().get(0));
        }
        return execution;
    }

    protected PvmExecutionImpl getDeleteRoot(PvmExecutionImpl execution) {
        if (execution == null) {
            return null;
        }
        if (execution.isDeleteRoot()) {
            return execution;
        }
        return this.getDeleteRoot(execution.getParent());
    }

    @Override
    public String getCanonicalName() {
        return "delete-cascade";
    }
}

