/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.pvm.runtime.operation;

import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import io.openbpm.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import io.openbpm.bpm.engine.impl.pvm.runtime.operation.AbstractPvmEventAtomicOperation;

public class PvmAtomicOperationProcessStart
extends AbstractPvmEventAtomicOperation {
    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        return execution.getActivity().isAsyncBefore();
    }

    @Override
    public boolean isAsyncCapable() {
        return true;
    }

    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "start";
    }

    @Override
    protected PvmExecutionImpl eventNotificationsStarted(PvmExecutionImpl execution) {
        execution.setProcessInstanceStarting(true);
        if (execution.getActivity() != null && execution.getActivity().isAsyncBefore()) {
            LegacyBehavior.createMissingHistoricVariables(execution);
        }
        return execution;
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        execution.continueIfExecutionDoesNotAffectNextOperation(execution1 -> {
            execution1.dispatchEvent(null);
            return null;
        }, execution2 -> {
            execution2.setIgnoreAsync(true);
            execution2.performOperation(ACTIVITY_START_CREATE_SCOPE);
            return null;
        }, execution);
    }

    @Override
    public String getCanonicalName() {
        return "process-start";
    }
}

