/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.runtime;

import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.repository.ProcessDefinition;
import io.openbpm.bpm.engine.runtime.Execution;
import io.openbpm.bpm.engine.runtime.MessageCorrelationResultType;

public class CorrelationHandlerResult {
    protected MessageCorrelationResultType resultType;
    protected ExecutionEntity executionEntity;
    protected ProcessDefinitionEntity processDefinitionEntity;
    protected String startEventActivityId;

    public static CorrelationHandlerResult matchedExecution(ExecutionEntity executionEntity) {
        CorrelationHandlerResult messageCorrelationResult = new CorrelationHandlerResult();
        messageCorrelationResult.resultType = MessageCorrelationResultType.Execution;
        messageCorrelationResult.executionEntity = executionEntity;
        return messageCorrelationResult;
    }

    public static CorrelationHandlerResult matchedProcessDefinition(ProcessDefinitionEntity processDefinitionEntity, String startEventActivityId) {
        CorrelationHandlerResult messageCorrelationResult = new CorrelationHandlerResult();
        messageCorrelationResult.processDefinitionEntity = processDefinitionEntity;
        messageCorrelationResult.startEventActivityId = startEventActivityId;
        messageCorrelationResult.resultType = MessageCorrelationResultType.ProcessDefinition;
        return messageCorrelationResult;
    }

    public ExecutionEntity getExecutionEntity() {
        return this.executionEntity;
    }

    public ProcessDefinitionEntity getProcessDefinitionEntity() {
        return this.processDefinitionEntity;
    }

    public String getStartEventActivityId() {
        return this.startEventActivityId;
    }

    public MessageCorrelationResultType getResultType() {
        return this.resultType;
    }

    public Execution getExecution() {
        return this.executionEntity;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinitionEntity;
    }
}

