/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.runtime;

import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.UpdateProcessInstancesSuspensionStateBuilderImpl;
import io.openbpm.bpm.engine.impl.cmd.ActivateProcessInstanceCmd;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.cmd.SuspendProcessInstanceCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import io.openbpm.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateBuilder;
import io.openbpm.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateSelectBuilder;
import io.openbpm.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateTenantBuilder;
import io.openbpm.bpm.engine.runtime.UpdateProcessInstancesSuspensionStateBuilder;
import java.util.List;

public class UpdateProcessInstanceSuspensionStateBuilderImpl
implements UpdateProcessInstanceSuspensionStateBuilder,
UpdateProcessInstanceSuspensionStateSelectBuilder,
UpdateProcessInstanceSuspensionStateTenantBuilder {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final CommandExecutor commandExecutor;
    protected String processInstanceId;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected String processDefinitionTenantId;
    protected boolean isProcessDefinitionTenantIdSet;

    public UpdateProcessInstanceSuspensionStateBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public UpdateProcessInstanceSuspensionStateBuilderImpl() {
        this(null);
    }

    @Override
    public UpdateProcessInstancesSuspensionStateBuilder byProcessInstanceIds(List<String> processInstanceIds) {
        return new UpdateProcessInstancesSuspensionStateBuilderImpl(this.commandExecutor).byProcessInstanceIds(processInstanceIds);
    }

    @Override
    public UpdateProcessInstancesSuspensionStateBuilder byProcessInstanceIds(String ... processInstanceIds) {
        return new UpdateProcessInstancesSuspensionStateBuilderImpl(this.commandExecutor).byProcessInstanceIds(processInstanceIds);
    }

    @Override
    public UpdateProcessInstancesSuspensionStateBuilder byProcessInstanceQuery(ProcessInstanceQuery processInstanceQuery) {
        return new UpdateProcessInstancesSuspensionStateBuilderImpl(this.commandExecutor).byProcessInstanceQuery(processInstanceQuery);
    }

    @Override
    public UpdateProcessInstancesSuspensionStateBuilder byHistoricProcessInstanceQuery(HistoricProcessInstanceQuery historicProcessInstanceQuery) {
        return new UpdateProcessInstancesSuspensionStateBuilderImpl(this.commandExecutor).byHistoricProcessInstanceQuery(historicProcessInstanceQuery);
    }

    @Override
    public UpdateProcessInstanceSuspensionStateBuilderImpl byProcessInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public UpdateProcessInstanceSuspensionStateBuilderImpl byProcessDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public UpdateProcessInstanceSuspensionStateBuilderImpl byProcessDefinitionKey(String processDefinitionKey) {
        EnsureUtil.ensureNotNull("processDefinitionKey", (Object)processDefinitionKey);
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public UpdateProcessInstanceSuspensionStateBuilderImpl processDefinitionWithoutTenantId() {
        this.processDefinitionTenantId = null;
        this.isProcessDefinitionTenantIdSet = true;
        return this;
    }

    @Override
    public UpdateProcessInstanceSuspensionStateBuilderImpl processDefinitionTenantId(String tenantId) {
        EnsureUtil.ensureNotNull("tenantId", (Object)tenantId);
        this.processDefinitionTenantId = tenantId;
        this.isProcessDefinitionTenantIdSet = true;
        return this;
    }

    @Override
    public void activate() {
        this.validateParameters();
        ActivateProcessInstanceCmd command = new ActivateProcessInstanceCmd(this);
        this.commandExecutor.execute(command);
    }

    @Override
    public void suspend() {
        this.validateParameters();
        SuspendProcessInstanceCmd command = new SuspendProcessInstanceCmd(this);
        this.commandExecutor.execute(command);
    }

    protected void validateParameters() {
        EnsureUtil.ensureOnlyOneNotNull("Need to specify either a process instance id, a process definition id or a process definition key.", this.processInstanceId, this.processDefinitionId, this.processDefinitionKey);
        if (this.isProcessDefinitionTenantIdSet && (this.processInstanceId != null || this.processDefinitionId != null)) {
            throw LOG.exceptionUpdateSuspensionStateForTenantOnlyByProcessDefinitionKey();
        }
        EnsureUtil.ensureNotNull("commandExecutor", (Object)this.commandExecutor);
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionTenantId() {
        return this.processDefinitionTenantId;
    }

    public boolean isProcessDefinitionTenantIdSet() {
        return this.isProcessDefinitionTenantIdSet;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }
}

