/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.scripting.engine;

import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.scripting.engine.ScriptEngineResolver;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;

public class DefaultScriptEngineResolver
implements ScriptEngineResolver {
    protected final ScriptEngineManager scriptEngineManager;
    protected Map<String, ScriptEngine> cachedEngines = new HashMap<String, ScriptEngine>();

    public DefaultScriptEngineResolver(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    @Override
    public void addScriptEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
    }

    @Override
    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    @Override
    public ScriptEngine getScriptEngine(String language, boolean resolveFromCache) {
        ScriptEngine scriptEngine = null;
        if (resolveFromCache) {
            scriptEngine = this.cachedEngines.get(language);
            if (scriptEngine == null && (scriptEngine = this.getScriptEngine(language)) != null && this.isCachable(scriptEngine)) {
                this.cachedEngines.put(language, scriptEngine);
            }
        } else {
            scriptEngine = this.getScriptEngine(language);
        }
        return scriptEngine;
    }

    protected ScriptEngine getScriptEngine(String language) {
        ScriptEngine scriptEngine = null;
        scriptEngine = "javascript".equalsIgnoreCase(language) || "ecmascript".equalsIgnoreCase(language) ? this.getJavaScriptScriptEngine(language) : this.scriptEngineManager.getEngineByName(language);
        if (scriptEngine != null) {
            this.configureScriptEngines(language, scriptEngine);
        }
        return scriptEngine;
    }

    protected ScriptEngine getJavaScriptScriptEngine(String language) {
        ScriptEngine scriptEngine = null;
        ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
        if (config != null && config.getScriptEngineNameJavaScript() != null) {
            scriptEngine = this.scriptEngineManager.getEngineByName(config.getScriptEngineNameJavaScript());
        } else {
            scriptEngine = this.scriptEngineManager.getEngineByName("Graal.js");
            if (scriptEngine == null) {
                scriptEngine = this.scriptEngineManager.getEngineByName(language);
            }
        }
        return scriptEngine;
    }

    protected boolean isCachable(ScriptEngine scriptEngine) {
        Object threadingParameter = scriptEngine.getFactory().getParameter("THREADING");
        return threadingParameter != null;
    }

    protected void configureScriptEngines(String language, ScriptEngine scriptEngine) {
        if ("groovy".equals(language)) {
            this.configureGroovyScriptEngine(scriptEngine);
        }
        if ("Graal.js".equals(scriptEngine.getFactory().getEngineName())) {
            this.configureGraalJsScriptEngine(scriptEngine);
        }
    }

    protected void configureGroovyScriptEngine(ScriptEngine scriptEngine) {
        scriptEngine.getContext().setAttribute("#jsr223.groovy.engine.keep.globals", "weak", 100);
    }

    protected void configureGraalJsScriptEngine(ScriptEngine scriptEngine) {
        ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
        if (config != null) {
            if (config.isConfigureScriptEngineHostAccess()) {
                scriptEngine.getContext().setAttribute("polyglot.js.allowHostAccess", true, 100);
                scriptEngine.getContext().setAttribute("polyglot.js.allowHostClassLookup", true, 100);
            }
            if (config.isEnableScriptEngineLoadExternalResources()) {
                scriptEngine.getContext().setAttribute("polyglot.js.allowIO", true, 100);
            }
            if (config.isEnableScriptEngineNashornCompatibility()) {
                scriptEngine.getContext().setAttribute("polyglot.js.nashorn-compat", true, 100);
            }
        }
    }
}

