/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.scripting.engine;

import java.util.List;
import java.util.Map;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;

public class OperatonScriptEngineManager
extends ScriptEngineManager {
    protected final Map<String, Runnable> engineNameToInitLogicMappings = Map.of("Graal.js", this::disableGraalVMInterpreterOnlyModeWarnings, "jython", this::disablePythonImportSiteWarnings);

    public OperatonScriptEngineManager() {
        this.applyConfigOnEnginesAfterClasspathDiscovery();
    }

    protected void applyConfigOnEnginesAfterClasspathDiscovery() {
        List<String> engineNames = this.getEngineNamesFoundInClasspath();
        for (String engineName : engineNames) {
            this.executeConfigurationBeforeEngineCreation(engineName);
        }
    }

    protected List<String> getEngineNamesFoundInClasspath() {
        List<ScriptEngineFactory> engineFactories = this.getEngineFactories();
        return engineFactories.stream().map(ScriptEngineFactory::getEngineName).toList();
    }

    protected void executeConfigurationBeforeEngineCreation(String engineName) {
        Runnable config = this.engineNameToInitLogicMappings.get(engineName);
        if (config != null) {
            config.run();
        }
    }

    protected void disableGraalVMInterpreterOnlyModeWarnings() {
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
    }

    protected void disablePythonImportSiteWarnings() {
        System.setProperty("python.import.site", "false");
    }
}

