/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.task;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.delegate.Expression;
import io.openbpm.bpm.engine.delegate.VariableScope;
import io.openbpm.bpm.engine.impl.calendar.BusinessCalendar;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.el.ExpressionManager;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.task.TaskDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class TaskDecorator {
    protected TaskDefinition taskDefinition;
    protected ExpressionManager expressionManager;

    public TaskDecorator(TaskDefinition taskDefinition, ExpressionManager expressionManager) {
        this.taskDefinition = taskDefinition;
        this.expressionManager = expressionManager;
    }

    public void decorate(TaskEntity task, VariableScope variableScope) {
        task.setTaskDefinition(this.taskDefinition);
        this.initializeTaskName(task, variableScope);
        this.initializeTaskDescription(task, variableScope);
        this.initializeTaskDueDate(task, variableScope);
        this.initializeTaskFollowUpDate(task, variableScope);
        this.initializeTaskPriority(task, variableScope);
        this.initializeTaskAssignments(task, variableScope);
    }

    protected void initializeTaskName(TaskEntity task, VariableScope variableScope) {
        Expression nameExpression = this.taskDefinition.getNameExpression();
        if (nameExpression != null) {
            String name = (String)nameExpression.getValue(variableScope);
            task.setName(name);
        }
    }

    protected void initializeTaskDescription(TaskEntity task, VariableScope variableScope) {
        Expression descriptionExpression = this.taskDefinition.getDescriptionExpression();
        if (descriptionExpression != null) {
            String description = (String)descriptionExpression.getValue(variableScope);
            task.setDescription(description);
        }
    }

    protected void initializeTaskDueDate(TaskEntity task, VariableScope variableScope) {
        Object dueDate;
        Expression dueDateExpression = this.taskDefinition.getDueDateExpression();
        if (dueDateExpression != null && (dueDate = dueDateExpression.getValue(variableScope)) != null) {
            if (dueDate instanceof Date) {
                Date date = (Date)dueDate;
                task.setDueDate(date);
            } else if (dueDate instanceof String) {
                String string = (String)dueDate;
                BusinessCalendar businessCalendar = this.getBusinessCalender();
                task.setDueDate(businessCalendar.resolveDuedate(string, task));
            } else {
                throw new ProcessEngineException("Due date expression does not resolve to a Date or Date string: " + dueDateExpression.getExpressionText());
            }
        }
    }

    protected void initializeTaskFollowUpDate(TaskEntity task, VariableScope variableScope) {
        Object followUpDate;
        Expression followUpDateExpression = this.taskDefinition.getFollowUpDateExpression();
        if (followUpDateExpression != null && (followUpDate = followUpDateExpression.getValue(variableScope)) != null) {
            if (followUpDate instanceof Date) {
                Date date = (Date)followUpDate;
                task.setFollowUpDate(date);
            } else if (followUpDate instanceof String) {
                String string = (String)followUpDate;
                BusinessCalendar businessCalendar = this.getBusinessCalender();
                task.setFollowUpDate(businessCalendar.resolveDuedate(string, task));
            } else {
                throw new ProcessEngineException("Follow up date expression does not resolve to a Date or Date string: " + followUpDateExpression.getExpressionText());
            }
        }
    }

    protected void initializeTaskPriority(TaskEntity task, VariableScope variableScope) {
        Object priority;
        Expression priorityExpression = this.taskDefinition.getPriorityExpression();
        if (priorityExpression != null && (priority = priorityExpression.getValue(variableScope)) != null) {
            if (priority instanceof String) {
                String string = (String)priority;
                try {
                    task.setPriority(Integer.parseInt(string));
                }
                catch (NumberFormatException e) {
                    throw new ProcessEngineException("Priority does not resolve to a number: " + priority, e);
                }
            } else if (priority instanceof Number) {
                Number number = (Number)priority;
                task.setPriority(number.intValue());
            } else {
                throw new ProcessEngineException("Priority expression does not resolve to a number: " + priorityExpression.getExpressionText());
            }
        }
    }

    protected void initializeTaskAssignments(TaskEntity task, VariableScope variableScope) {
        this.initializeTaskAssignee(task, variableScope);
        this.initializeTaskCandidateUsers(task, variableScope);
        this.initializeTaskCandidateGroups(task, variableScope);
    }

    protected void initializeTaskAssignee(TaskEntity task, VariableScope variableScope) {
        Expression assigneeExpression = this.taskDefinition.getAssigneeExpression();
        if (assigneeExpression != null) {
            task.setAssignee((String)assigneeExpression.getValue(variableScope));
        }
    }

    protected void initializeTaskCandidateGroups(TaskEntity task, VariableScope variableScope) {
        Set<Expression> candidateGroupIdExpressions = this.taskDefinition.getCandidateGroupIdExpressions();
        for (Expression groupIdExpr : candidateGroupIdExpressions) {
            Object value = groupIdExpr.getValue(variableScope);
            if (value instanceof String) {
                String string = (String)value;
                List<String> candiates = this.extractCandidates(string);
                task.addCandidateGroups(candiates);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                task.addCandidateGroups(collection);
                continue;
            }
            throw new ProcessEngineException("Expression did not resolve to a string or collection of strings");
        }
    }

    protected void initializeTaskCandidateUsers(TaskEntity task, VariableScope variableScope) {
        Set<Expression> candidateUserIdExpressions = this.taskDefinition.getCandidateUserIdExpressions();
        for (Expression userIdExpr : candidateUserIdExpressions) {
            Object value = userIdExpr.getValue(variableScope);
            if (value instanceof String) {
                String string = (String)value;
                List<String> candiates = this.extractCandidates(string);
                task.addCandidateUsers(candiates);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                task.addCandidateUsers(collection);
                continue;
            }
            throw new ProcessEngineException("Expression did not resolve to a string or collection of strings");
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    protected BusinessCalendar getBusinessCalender() {
        return Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar("dueDate");
    }
}

