/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.task.listener;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.delegate.BaseDelegateExecution;
import io.openbpm.bpm.engine.delegate.DelegateTask;
import io.openbpm.bpm.engine.delegate.Expression;
import io.openbpm.bpm.engine.delegate.TaskListener;
import io.openbpm.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.task.delegate.TaskListenerInvocation;
import io.openbpm.bpm.engine.impl.util.ClassDelegateUtil;
import java.util.List;

public class DelegateExpressionTaskListener
implements TaskListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionTaskListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void notify(DelegateTask delegateTask) {
        BaseDelegateExecution variableScope = delegateTask.getExecution();
        if (variableScope == null) {
            variableScope = delegateTask.getCaseExecution();
        }
        Object delegate = this.expression.getValue(variableScope);
        ClassDelegateUtil.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (delegate instanceof TaskListener) {
            TaskListener taskListener = (TaskListener)delegate;
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(taskListener, delegateTask));
            }
            catch (Exception e) {
                throw new ProcessEngineException("Exception while invoking TaskListener: " + e.getMessage(), e);
            }
        } else {
            throw new ProcessEngineException("Delegate expression " + this.expression + " did not resolve to an implementation of " + TaskListener.class);
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }

    public List<FieldDeclaration> getFieldDeclarations() {
        return this.fieldDeclarations;
    }
}

